/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.containers.ExasolContainer;
import com.exasol.containers.ExasolContainerException;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import org.testcontainers.containers.Container;

public class ContainerFileOperations {
    private final ExasolContainer<? extends ExasolContainer<?>> container;

    public ContainerFileOperations(ExasolContainer<? extends ExasolContainer<?>> container) {
        this.container = container;
    }

    public String readFile(String pathInContainer, Charset outputCharset) throws ExasolContainerException {
        try {
            Container.ExecResult result = this.container.execInContainer(outputCharset, "cat", pathInContainer);
            if (!result.getStderr().isBlank()) {
                String errorMessage = result.getStderr().trim();
                throw new ExasolContainerException(ExaError.messageBuilder((String)"F-ETC-10").message("Unable to read file {{path}} from container. Error message: {{errorMessage}}.", new Object[0]).parameter("path", (Object)pathInContainer, "path inside the container").parameter("errorMessage", (Object)errorMessage, "error message returned by command").toString(), null);
            }
            return result.getStdout();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETC-12").message("InterruptedException when reading file content", new Object[0]).toString(), exception);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder((String)"F-ETC-11").message("Unable to read file {{path}} from container.", new Object[]{pathInContainer}).toString(), exception);
        }
    }
}

