/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.status;

import com.exasol.containers.status.ContainerStatus;
import com.exasol.containers.status.ContainerStatusCacheException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerStatusCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerStatusCache.class);
    static final String CACHE_FILE_EXTENSION = ".cache";
    private final Path cacheDirectory;

    public ContainerStatusCache(Path tempDirectory) {
        this.cacheDirectory = tempDirectory;
    }

    public Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    public boolean isCacheAvailable(String containerId) {
        Path cacheFile = this.getCacheFileForContainer(containerId);
        return Files.exists(cacheFile, new LinkOption[0]);
    }

    private Path getCacheFileForContainer(String containerId) {
        return this.cacheDirectory.resolve(containerId + CACHE_FILE_EXTENSION);
    }

    public ContainerStatus read(String containerId) {
        return this.readFromCacheFile(this.getCacheFileForContainer(containerId));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ContainerStatus readFromCacheFile(Path cacheFile) {
        LOGGER.debug("Reading container state from cache file \"{}\".", (Object)cacheFile);
        try (FileInputStream inputStream = new FileInputStream(cacheFile.toFile());){
            ContainerStatus containerStatus;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
                containerStatus = (ContainerStatus)objectInputStream.readObject();
            }
            return containerStatus;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new ContainerStatusCacheException("Unable to read container state from cache file '" + cacheFile + "'.", exception);
        }
    }

    public void write(String containerId, ContainerStatus containerStatus) {
        this.createMissingCacheDirectory();
        this.writeToFile(this.getCacheFileForContainer(containerId), containerStatus);
    }

    private void createMissingCacheDirectory() {
        if (!Files.exists(this.cacheDirectory, new LinkOption[0])) {
            LOGGER.debug("Container status directory \"{}\" does not exist. Creating.", (Object)this.cacheDirectory);
            try {
                Files.createDirectories(this.cacheDirectory, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new ContainerStatusCacheException("Unable to container status cache directory \"" + this.cacheDirectory + "\".", exception);
            }
        }
    }

    private void writeToFile(Path cacheFile, ContainerStatus containerStatus) {
        LOGGER.debug("Writing container status to cache file \"{}\".", (Object)cacheFile);
        try (FileOutputStream outputStream = new FileOutputStream(cacheFile.toFile());
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
            objectOutputStream.writeObject(containerStatus);
        }
        catch (IOException exception) {
            throw new ContainerStatusCacheException("Unable to write container status to cache file \"" + cacheFile + "\".", exception);
        }
    }
}

