/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.testcontainers;

import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.ReadOnlyBucket;
import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.bucketfs.monitor.TimestampRetriever;
import com.exasol.clusterlogs.LogPatternDetector;
import com.exasol.clusterlogs.LogPatternDetectorFactory;
import com.exasol.containers.ssh.SshException;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;

public class LogBasedBucketFsMonitor
implements BucketFsMonitor {
    private final LogPatternDetectorFactory detectorFactory;
    private final FilterStrategy filterStrategy;

    public LogBasedBucketFsMonitor(LogPatternDetectorFactory detectorFactory, FilterStrategy filterStrategy) {
        this.detectorFactory = detectorFactory;
        this.filterStrategy = filterStrategy;
    }

    public boolean isObjectSynchronized(ReadOnlyBucket bucket, String pathInBucket, BucketFsMonitor.State state) throws BucketAccessException {
        try {
            return this.createBucketLogPatternDetector(pathInBucket, state).isPatternPresent();
        }
        catch (SshException | IOException exception) {
            throw new BucketAccessException(ExaError.messageBuilder((String)"E-ETC-19").message("Unable to check if object {{path}} is synchronized in bucket {{bucket filesystem}}/{{bucket name}}.", new Object[]{pathInBucket, bucket.getBucketFsName(), bucket.getBucketName()}).toString(), (Throwable)exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETC-20").message("Caught interrupt trying to check if object {{path}} is synchronized in bucket {{bucket filesystem}}/{{bucket name}}.", new Object[]{pathInBucket, bucket.getBucketFsName(), bucket.getBucketName()}).toString(), exception);
        }
    }

    private LogPatternDetector createBucketLogPatternDetector(String pathInBucket, BucketFsMonitor.State state) {
        return this.detectorFactory.createLogPatternDetector("/exa/logs/cored", "bucketfsd.*.log", this.detectorFactory.getLogPatternProvider().pattern(pathInBucket), state);
    }

    public BucketFsMonitor.StateRetriever createStateRetriever() {
        switch (this.filterStrategy) {
            case LINE_NUMBER: {
                return this.detectorFactory.createLineCountRetriever("/exa/logs/cored", "bucketfsd.*.log");
            }
        }
        return new TimestampRetriever();
    }

    public static enum FilterStrategy {
        TIME_STAMP,
        LINE_NUMBER;

    }
}

