/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.errorreporting.ExaError;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.NetworkSettings;
import java.util.Map;
import org.testcontainers.containers.Container;

public class HostIpDetector {
    private final Container<? extends Container<?>> container;

    public HostIpDetector(Container<? extends Container<?>> container) {
        this.container = container;
    }

    public String getHostIp() {
        NetworkSettings networkSettings = this.container.getContainerInfo().getNetworkSettings();
        Map networks = networkSettings.getNetworks();
        if (networks.size() == 0) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETC-3").message("Unable to determine host IP for {{docker-image}} container because the docker network had no entries.", new Object[0]).parameter("docker-image", (Object)this.container.getDockerImageName(), "Docker image name").toString());
        }
        return ((ContainerNetwork)networks.values().iterator().next()).getGateway();
    }
}

