/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.slc;

import com.exasol.containers.UncheckedSqlException;
import com.exasol.containers.slc.SlcConfiguration;
import com.exasol.errorreporting.ExaError;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SlcConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlcConfigurator.class);
    private final Connection connection;

    SlcConfigurator(Connection connection) {
        this.connection = connection;
    }

    SlcConfiguration read() {
        return SlcConfiguration.parse(this.getScriptLanguagesSystemValue());
    }

    void write(SlcConfiguration config) {
        String value = this.escapeQuotes(config.format());
        LOGGER.debug("Writing SLC configuration to database: {}", (Object)value);
        try (Statement statement = this.connection.createStatement();){
            statement.execute("ALTER SYSTEM SET SCRIPT_LANGUAGES='" + value + "'");
            statement.execute("ALTER SESSION SET SCRIPT_LANGUAGES='" + value + "'");
        }
        catch (SQLException exception) {
            throw new UncheckedSqlException(ExaError.messageBuilder((String)"E-ETC-32").message("Failed to write SLC configuration to the database", new Object[0]).toString(), exception);
        }
    }

    private String escapeQuotes(String config) {
        return config.replace("'", "''");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getScriptLanguagesSystemValue() {
        String query = "SELECT system_value FROM exa_parameters WHERE parameter_name='SCRIPT_LANGUAGES'";
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT system_value FROM exa_parameters WHERE parameter_name='SCRIPT_LANGUAGES'");
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) throw new IllegalStateException("No SLC configuration found.");
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException exception) {
            throw new UncheckedSqlException(ExaError.messageBuilder((String)"E-ETC-33").message("Failed to read SLC configuration using query {{query}}", new Object[]{"SELECT system_value FROM exa_parameters WHERE parameter_name='SCRIPT_LANGUAGES'"}).toString(), exception);
        }
    }
}

