/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.slc.fileprovider;

import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UrlDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlDownloader.class);

    UrlDownloader() {
    }

    void download(URL url, Path targetPath) {
        LOGGER.debug("Downloading URL {} to {}...", (Object)url, (Object)targetPath);
        Instant start = Instant.now();
        try (InputStream in = url.openStream();){
            long fileSize = Files.copy(in, targetPath, StandardCopyOption.REPLACE_EXISTING);
            Duration duration = Duration.between(start, Instant.now());
            LOGGER.debug("Downloaded {} with size {} bytes in {}.", new Object[]{targetPath, fileSize, duration});
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder((String)"E-ETC-38").message("Failed to download file from URL {{url}} to target path {{target path}}: {{error message|uq}}", new Object[]{url, targetPath, exception.toString()}).toString(), exception);
        }
    }
}

