/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.exasol.containers.ssh.Ssh;
import com.exasol.containers.ssh.SshConnection;
import com.exasol.containers.ssh.SshException;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;

class FileVisitor {
    private static final byte[] ZERO_BUFFER = new byte[]{0};
    private final Ssh ssh;
    private static final int ERROR = 1;
    private static final int FATAL_ERROR = 2;

    FileVisitor(Ssh ssh) {
        this.ssh = ssh;
    }

    String visit(String remoteFilePath, ContentProcessor consumer) throws IOException, JSchException {
        String command = String.format("scp -f '%s'", remoteFilePath.replace("'", "'\\''"));
        Channel channel = this.ssh.openChannel("exec");
        ((ChannelExec)channel).setCommand(command);
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();
        try (SshConnection connection = new SshConnection(channel);){
            String result = null;
            do {
                FileVisitor.sendZeroByte(out);
                if (FileVisitor.checkAck(in) != 67) {
                    String string = result;
                    return string;
                }
                this.readFileMode(in);
                int fileSize = this.readFileSize(in);
                this.readFilename(in);
                FileVisitor.sendZeroByte(out);
                result = consumer.process(in, this.ssh.getCharset(), fileSize);
            } while (FileVisitor.checkAck(in) == 0);
            throw new SshException("ack != 0");
        }
    }

    static void sendZeroByte(OutputStream stream) throws IOException {
        stream.write(ZERO_BUFFER, 0, 1);
        stream.flush();
    }

    private String readFileMode(InputStream stream) throws IOException {
        byte[] buf = new byte[5];
        stream.read(buf, 0, 5);
        return new String(buf, 0, 5);
    }

    private int readFileSize(InputStream in) throws IOException {
        int filesize = 0;
        byte[] buf = new byte[1];
        while (true) {
            if (in.read(buf, 0, 1) < 0) {
                throw new SshException("Failed to read filesize");
            }
            if (buf[0] == 32) {
                return filesize;
            }
            filesize = filesize * 10 + buf[0] - 48;
        }
    }

    private String readFilename(InputStream stream) throws IOException {
        byte[] buf = new byte[1024];
        int i = 0;
        while (true) {
            stream.read(buf, i, 1);
            if (buf[i] == 10) {
                return new String(buf, 0, i);
            }
            ++i;
        }
    }

    static String fileHeader(Path file) throws IOException {
        return FileVisitor.fileHeader('C', "0644", Files.size(file), file.getFileName().toString());
    }

    static String fileHeader(char ack, String mode, long filesize, String filename) {
        return String.format("%c%s %d %s%c", Character.valueOf(ack), mode, filesize, filename, 10);
    }

    static int checkAck(InputStream stream) throws IOException {
        int b = stream.read();
        if (b == 1 || b == 2) {
            throw new SshException("Error " + FileVisitor.getErrorMessage(stream));
        }
        return b;
    }

    static String getErrorMessage(InputStream stream) throws IOException {
        StringBuilder builder = new StringBuilder();
        int c = 0;
        while (c != 10) {
            c = stream.read();
            builder.append((char)c);
        }
        return builder.toString();
    }

    @FunctionalInterface
    static interface ContentProcessor {
        public String process(InputStream var1, Charset var2, int var3) throws IOException;
    }

    static enum State {
        CONTINUE,
        COMPLETED,
        ERROR;

    }
}

