/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.exasol.containers.ssh.FileVisitor;
import com.exasol.containers.ssh.Ssh;
import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class RemoteFileParser {
    private final FileVisitor visitor;
    private LineMatcher lineMatcher;

    RemoteFileParser(Ssh ssh) {
        this.visitor = new FileVisitor(ssh);
    }

    String findMatch(String rfile, LineMatcher lineMatcher) throws IOException, JSchException {
        this.lineMatcher = lineMatcher;
        return this.visitor.visit(rfile, this::process);
    }

    String process(InputStream stream, Charset charset, long filesize) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!this.lineMatcher.matches(line)) continue;
                String string = line;
                return string;
            }
        }
        return null;
    }

    @FunctionalInterface
    public static interface LineMatcher {
        public boolean matches(String var1);
    }
}

