/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry<T extends Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Retry.class);
    private final Class<T> exceptionClass;
    private final Duration timeout;
    private final Duration interval;
    private Instant start;

    public Retry(Class<T> exceptionClass, Duration timeout) {
        this.exceptionClass = exceptionClass;
        this.timeout = timeout;
        this.interval = Duration.ofSeconds(3L);
    }

    public void retry(RunnableWthException<T> runnable) throws T {
        this.start = Instant.now();
        int i = 0;
        while (true) {
            try {
                runnable.run();
                return;
            }
            catch (Exception exception) {
                if (!this.exceptionClass.isInstance(exception) || this.stop()) {
                    throw exception;
                }
                LOGGER.trace("{} - {}. retry after {} seconds", new Object[]{exception.getMessage(), i + 1, this.elapsed().plus(this.interval).toSeconds()});
                try {
                    Thread.sleep(this.interval.toMillis());
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private Duration elapsed() {
        return Duration.between(this.start, Instant.now());
    }

    private boolean stop() {
        return this.timeout.minus(this.elapsed()).isNegative();
    }

    @FunctionalInterface
    public static interface RunnableWthException<E extends Exception> {
        public void run() throws E;
    }
}

