/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.wait.strategy;

import com.exasol.clusterlogs.LogPatternDetectorFactory;
import com.exasol.containers.wait.strategy.LogFileEntryWaitStrategy;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketFsWaitStrategy
extends LogFileEntryWaitStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketFsWaitStrategy.class);
    static final String BUCKETFS_READY_PATTERN = "UNPACK THREAD started$";

    public BucketFsWaitStrategy(LogPatternDetectorFactory detectorFactory) {
        super(detectorFactory.createLogPatternDetector("/exa/logs/cored", "bucketfsd.*.log", BUCKETFS_READY_PATTERN));
    }

    @Override
    protected void waitUntilReady() {
        LOGGER.debug("Waiting {} for BucketFS to be ready.", (Object)this.startupTimeout);
        Instant start = Instant.now();
        super.waitUntilReady();
        LOGGER.debug("BucketFS is ready after {}.", (Object)Duration.between(start, Instant.now()));
    }
}

