/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.drivers;

import com.exasol.bucketfs.Bucket;
import com.exasol.bucketfs.BucketAccessException;
import com.exasol.drivers.DatabaseDriver;
import com.exasol.drivers.DriverManagerException;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExasolDriverManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExasolDriverManager.class);
    private static final String MANIFEST_FILENAME = "settings.cfg";
    static final String DEFAULT_JDBC_DRIVER_PATH_IN_BUCKET = "drivers/jdbc";
    static final String MANIFEST_PATH_IN_BUCKET = "drivers/jdbc/settings.cfg";
    private final Map<String, DatabaseDriver> installedDrivers = new HashMap<String, DatabaseDriver>();
    private final Bucket bucket;

    public ExasolDriverManager(Bucket bucket) {
        this.bucket = bucket;
    }

    public void install(DatabaseDriver ... drivers) {
        for (DatabaseDriver driver : drivers) {
            this.installDriver(driver);
        }
    }

    private void installDriver(DatabaseDriver driver) {
        this.registerDriver(driver);
        if (driver.hasSourceFile()) {
            LOGGER.debug("Installing driver {}", (Object)driver);
            this.uploadDriver(driver);
        } else {
            LOGGER.debug("Registering driver {} without uploading it. Make sure it is already present when using this feature!", (Object)driver);
        }
        this.uploadManifest(this.getManifest());
    }

    private void registerDriver(DatabaseDriver driver) {
        this.installedDrivers.put(driver.getName(), driver);
    }

    private void uploadDriver(DatabaseDriver driver) {
        try {
            String pathInBucket = "drivers/jdbc/" + driver.getFileName();
            this.bucket.uploadFile(driver.getSourcePath(), pathInBucket);
        }
        catch (FileNotFoundException exception) {
            throw new DriverManagerException("Driver file not found.", driver, exception);
        }
        catch (BucketAccessException | TimeoutException exception) {
            throw new DriverManagerException("Unable to upload database driver.", driver, exception);
        }
    }

    private void uploadManifest(String manifest) {
        try {
            this.bucket.uploadStringContent(manifest, MANIFEST_PATH_IN_BUCKET);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new DriverManagerException("Interrupted during upload of database driver manifest upload to \"drivers/jdbc/settings.cfg\"", exception);
        }
        catch (BucketAccessException | TimeoutException exception) {
            throw new DriverManagerException("Unable to upload database driver manifest to \"drivers/jdbc/settings.cfg\"", exception);
        }
    }

    public Collection<DatabaseDriver> getDrivers() {
        return this.installedDrivers.values();
    }

    public String getManifest() {
        return this.installedDrivers.values().stream().map(DatabaseDriver::getManifest).collect(Collectors.joining("\n"));
    }
}

