/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exaoperation.plugin;

import com.exasol.containers.ssh.SshException;
import com.exasol.exaoperation.ExaOperationEmulatorException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public class Plugin {
    public static final String PLUGIN_PACKAGE_PREFIX = "Plugin.";
    private static final Logger LOGGER = LoggerFactory.getLogger(Plugin.class);
    private static final Pattern PLUGIN_PACKAGE_FILENAME_PATTERN = Pattern.compile("Plugin\\.([-.\\w]+?-\\d+(?:\\.\\d{1,20}){1,20}).*");
    private final Path sourcePath;
    private final String name;
    private final Container<? extends Container<?>> container;

    public Plugin(Path sourcePath, Container<? extends Container<?>> container) {
        this.sourcePath = sourcePath;
        this.container = container;
        this.name = this.getPluginNameFromPackage(sourcePath);
    }

    private String getPluginNameFromPackage(Path sourcePath) {
        String filename = sourcePath.getFileName().toString();
        Matcher matcher = PLUGIN_PACKAGE_FILENAME_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Illegal plug-in package filename \"" + filename + "\". Must match: " + String.valueOf(PLUGIN_PACKAGE_FILENAME_PATTERN));
    }

    public String getName() {
        return this.name;
    }

    public Path getSourcePath() {
        return this.sourcePath;
    }

    public String getFileName() {
        return this.sourcePath.getFileName().toString();
    }

    public Container.ExecResult install() {
        return this.callFunction("install");
    }

    public Container.ExecResult callFunction(String method) {
        return this.callFunction(method, "");
    }

    public Container.ExecResult callFunction(String method, String argument) {
        if (null == argument) {
            throw new ExaOperationEmulatorException("Argument of Plugin::callFunction must never be null!");
        }
        return this.callFunctionInternal(method, argument);
    }

    private Container.ExecResult callFunctionInternal(String method, String ... argument) {
        if (argument.length > 1) {
            throw new ExaOperationEmulatorException("Internal error: Multiple arguments provided when calling function \"" + method + "\" of plugin \"" + this.name + "\"");
        }
        try {
            String script = "/usr/opt/EXAplugins/" + this.name + "/exaoperation-gate/plugin-functions";
            LOGGER.debug("Calling function \"{}\" of plug-in \"{}\".", (Object)method, (Object)this.name);
            if (argument.length == 1) {
                return this.container.execInContainer(new String[]{script, method, argument[0]});
            }
            return this.container.execInContainer(new String[]{script, method});
        }
        catch (SshException | IOException | UnsupportedOperationException exception) {
            throw new ExaOperationEmulatorException("Unable to run \"" + method + "\" script of plug-in \"" + this.name + "\".", exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new ExaOperationEmulatorException("Script \"" + method + "\" of plug-in \"" + this.name + "\" got interrupted.");
        }
    }

    public List<String> listFunctions() {
        Container.ExecResult result = this.callFunctionInternal("--show-functions", new String[0]);
        if (result.getExitCode() != 0) {
            throw new ExaOperationEmulatorException("--show-functions of plug-in \"" + this.name + "\" failed; error output:\n " + result.getStderr());
        }
        ArrayList<String> functions = new ArrayList<String>();
        for (String line : result.getStdout().split("\n")) {
            if (line.trim().isEmpty()) continue;
            functions.add(line);
        }
        return functions;
    }

    public Container.ExecResult start() {
        return this.callFunction("start");
    }

    public Container.ExecResult stop() {
        return this.callFunction("stop");
    }

    public Container.ExecResult restart() {
        return this.callFunction("restart");
    }

    public Container.ExecResult status() {
        return this.callFunction("status");
    }

    public Container.ExecResult uninstall() {
        return this.callFunction("uninstall");
    }
}

