/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.support;

import com.exasol.containers.ExitType;
import com.exasol.containers.ssh.SshException;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;

public class SupportInformationRetriever {
    public static final String TARGET_DIRECTORY_PROPERTY = "com.exasol.containers.support_information_target_dir";
    public static final String MONITORED_EXIT_PROPERTY = "com.exasol.containers.monitored_exit";
    static final String SUPPORT_ARCHIVE_PREFIX = "exacluster_debuginfo_";
    private static final String[] EXASUPPORT_COMMAND = new String[]{"exasupport", "-d", "0"};
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportInformationRetriever.class);
    private static final String MAPPED_HOST_DIRECTORY = "/exa/tmp/support";
    private static final ExitType DEFAULT_MONITORED_EXIT_TYPE = ExitType.EXIT_NONE;
    private final Container<? extends Container<?>> container;
    private Path targetDirectory;
    private ExitType monitoredExitType;

    public SupportInformationRetriever(Container<? extends Container<?>> container) {
        this.container = container;
        String monitoredExitPropertyValue = System.getProperty(MONITORED_EXIT_PROPERTY);
        this.getSettingsFromPropertiesOrDefaultValues(monitoredExitPropertyValue);
    }

    private void getSettingsFromPropertiesOrDefaultValues(String monitoredExitPropertyValue) {
        this.monitorExit(monitoredExitPropertyValue == null ? DEFAULT_MONITORED_EXIT_TYPE : ExitType.valueOf(monitoredExitPropertyValue));
        String targetDirectoryPropertyValue = System.getProperty(TARGET_DIRECTORY_PROPERTY);
        if (targetDirectoryPropertyValue != null) {
            this.mapTargetDirectory(Path.of(targetDirectoryPropertyValue, new String[0]));
        }
    }

    public void mapTargetDirectory(Path targetDirectory) {
        this.targetDirectory = targetDirectory;
        this.container.withFileSystemBind(targetDirectory.toString(), MAPPED_HOST_DIRECTORY, BindMode.READ_WRITE);
    }

    public void monitorExit(ExitType exitType) {
        this.monitoredExitType = exitType;
    }

    public void run(ExitType exitType) {
        if (this.monitoredExitType == ExitType.EXIT_ANY || exitType == this.monitoredExitType) {
            this.createArchiveBundle(exitType);
        } else {
            LOGGER.debug("Skipping support package creation. Exit type is {}, monitoring {}", (Object)exitType, (Object)this.monitoredExitType);
        }
    }

    private void createArchiveBundle(ExitType exitType) {
        try {
            Container.ExecResult result = this.container.execInContainer(EXASUPPORT_COMMAND);
            if (result.getExitCode() == 0) {
                String filename = this.extractFilenameFromConsoleMessage(result);
                String hostPath = this.getHostPath(filename);
                this.logSuccessfulArchiveCreationAttempt(exitType, hostPath);
            } else {
                this.logFailedSupportArchiveCreationAttempt(exitType, result.getStderr());
            }
        }
        catch (SshException | IOException | UnsupportedOperationException exception) {
            this.logFailedSupportArchiveCreationAttempt(exitType, exception.getMessage());
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(exception);
        }
    }

    private void logSuccessfulArchiveCreationAttempt(ExitType exitType, String pathOfArchiveOnHost) {
        LOGGER.info("Container exiting with {}. Monitoring is set to {}. Wrote support archive to: {}", new Object[]{exitType, this.monitoredExitType, pathOfArchiveOnHost});
    }

    private String extractFilenameFromConsoleMessage(Container.ExecResult result) {
        String consoleMessage = result.getStdout().strip();
        return consoleMessage.substring(consoleMessage.indexOf(SUPPORT_ARCHIVE_PREFIX));
    }

    private String getHostPath(String filename) {
        return this.targetDirectory.resolve(filename).toString();
    }

    private void logFailedSupportArchiveCreationAttempt(ExitType exitType, String cause) {
        LOGGER.error(ExaError.messageBuilder((String)"E-ETC-2").message("Container exiting with {{exit type}}. Monitoring is set to {{monitored exit type}}. Unable to create support archive {{archive}}.\nCause: {{cause}}", new Object[]{exitType, this.monitoredExitType, this.targetDirectory, cause}).toString());
    }
}

