/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.containers.ExasolContainerException;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.time.Instant;
import org.testcontainers.containers.Container;

public class ContainerTimeService {
    private final Container<? extends Container<?>> container;

    public static ContainerTimeService create(Container<? extends Container<?>> container) {
        return new ContainerTimeService(container);
    }

    private ContainerTimeService(Container<? extends Container<?>> container) {
        this.container = container;
    }

    public Instant getTime() {
        return Instant.ofEpochMilli(this.getMillisSinceEpochUtc());
    }

    public long getMillisSinceEpochUtc() {
        try {
            Container.ExecResult result = this.container.execInContainer(new String[]{"date", "+%s%3N"});
            if (result.getExitCode() == 0) {
                return Long.parseLong(result.getStdout().trim());
            }
            throw new ExasolContainerException(ExaError.messageBuilder((String)"E-ETC-18").message("Unable to get ISO time from container via 'date' command: {{error}}", new Object[0]).parameter("error", (Object)result.getStderr(), "Error output of command").toString());
        }
        catch (IOException | UnsupportedOperationException exception) {
            throw new ExasolContainerException(ExaError.messageBuilder((String)"E-ETC-16").message("Unable to get current time from container trying to check synchronization with host.", new Object[0]).toString(), exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new ExasolContainerException(exception);
        }
    }
}

