/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.slc;

import com.exasol.errorreporting.ExaError;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public final class ScriptLanguageContainer
implements Serializable {
    private static final long serialVersionUID = -3295522116885302191L;
    private final Language language;
    private final String alias;
    private final String udfEntryPoint;
    private final String localFile;
    private final String url;
    private final String sha512sum;

    private ScriptLanguageContainer(Builder builder) {
        this.language = Objects.requireNonNull(builder.language, "language");
        this.alias = builder.alias;
        this.localFile = builder.localFile;
        this.url = builder.url;
        this.sha512sum = builder.sha512sum;
        this.udfEntryPoint = builder.udfEntryPoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.language.getDefaultAlias();
    }

    public String getUdfEntryPoint() {
        if (this.udfEntryPoint != null) {
            return this.udfEntryPoint;
        }
        return this.language.getDefaultUdfEntryPoint();
    }

    public Path getLocalFile() {
        return Optional.ofNullable(this.localFile).map(x$0 -> Path.of(x$0, new String[0])).orElse(null);
    }

    public URL getUrl() {
        return Optional.ofNullable(this.url).map(ScriptLanguageContainer::parseUrl).orElse(null);
    }

    private static URL parseUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException exception) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-36").message("Invalid SLC URL: {{url}}", new Object[]{url}).toString(), exception);
        }
    }

    public String getSha512sum() {
        return this.sha512sum;
    }

    public String toString() {
        return "ScriptLanguageContainer [language=" + String.valueOf((Object)this.language) + ", alias=" + this.alias + ", udfEntryPoint=" + this.udfEntryPoint + ", localFile=" + this.localFile + ", url=" + this.url + ", sha512sum=" + this.sha512sum + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.alias, this.localFile, this.udfEntryPoint, this.url, this.sha512sum});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptLanguageContainer other = (ScriptLanguageContainer)obj;
        return this.language == other.language && Objects.equals(this.alias, other.alias) && Objects.equals(this.udfEntryPoint, other.udfEntryPoint) && Objects.equals(this.localFile, other.localFile) && Objects.equals(this.url, other.url) && Objects.equals(this.sha512sum, other.sha512sum);
    }

    public static enum Language {
        JAVA("java", "JAVA", "/exaudf/exaudfclient"),
        R("r", "R", "/exaudf/exaudfclient"),
        PYTHON("python", "PYTHON3", "/exaudf/exaudfclient_py3");

        private final String name;
        private final String defaultAlias;
        private final String defaultUdfEntryPoint;

        private Language(String name, String defaultAlias, String defaultUdfEntryPoint) {
            this.name = name;
            this.defaultAlias = defaultAlias;
            this.defaultUdfEntryPoint = defaultUdfEntryPoint;
        }

        String getDefaultUdfEntryPoint() {
            return this.defaultUdfEntryPoint;
        }

        String getDefaultAlias() {
            return this.defaultAlias;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Builder {
        private String udfEntryPoint;
        private Language language;
        private String alias;
        private String localFile;
        private String url;
        private String sha512sum;

        private Builder() {
        }

        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder udfEntryPoint(String udfEntryPoint) {
            this.udfEntryPoint = udfEntryPoint;
            return this;
        }

        public Builder localFile(Path localFile) {
            this.localFile = localFile.toString();
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder slcRelease(String version, String fileName) {
            return this.url("https://extensions-internal.exasol.com/com.exasol/script-languages-release/" + version + "/" + fileName);
        }

        public Builder sha512sum(String sha512sum) {
            this.sha512sum = sha512sum;
            return this;
        }

        public ScriptLanguageContainer build() {
            return new ScriptLanguageContainer(this);
        }
    }
}

