/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.slc;

import com.exasol.bucketfs.Bucket;
import com.exasol.bucketfs.BucketAccessException;
import com.exasol.containers.ExasolContainer;
import com.exasol.containers.slc.ScriptLanguageContainer;
import com.exasol.containers.slc.SlcConfiguration;
import com.exasol.containers.slc.SlcConfigurator;
import com.exasol.containers.slc.SlcUrlFormatter;
import com.exasol.containers.slc.fileprovider.FileProvider;
import com.exasol.errorreporting.ExaError;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class ScriptLanguageContainerInstaller {
    private static final List<String> SUPPORTED_SLC_FILE_EXTENSIONS = List.of(".tar.gz", ".tar.bz2", ".zip");
    private final Bucket bucket;
    private final SlcConfigurator slcConfigurator;
    private final SlcUrlFormatter slcUrlFormatter;

    ScriptLanguageContainerInstaller(Bucket bucket, SlcConfigurator slcConfigurator, SlcUrlFormatter slcUrlFormatter) {
        this.bucket = bucket;
        this.slcConfigurator = slcConfigurator;
        this.slcUrlFormatter = slcUrlFormatter;
    }

    public static ScriptLanguageContainerInstaller create(ExasolContainer<?> container) {
        return ScriptLanguageContainerInstaller.create(container.createConnection(), container.getDefaultBucket());
    }

    public static ScriptLanguageContainerInstaller create(Connection connection, Bucket bucket) {
        return new ScriptLanguageContainerInstaller(bucket, new SlcConfigurator(connection), new SlcUrlFormatter());
    }

    public void install(ScriptLanguageContainer slc) {
        FileProvider fileProvider = FileProvider.forSlc(slc);
        this.validateSlc(slc, fileProvider);
        Path localFile = fileProvider.getLocalFile();
        String fileName = localFile.getFileName().toString();
        this.uploadToBucketFs(localFile, fileName);
        this.updateSlcConfiguration(slc, fileName);
    }

    private void uploadToBucketFs(Path file, String pathInBucket) {
        try {
            this.bucket.uploadFile(file, pathInBucket);
        }
        catch (BucketAccessException | FileNotFoundException | TimeoutException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETC-34").message("Failed to upload local file file {{file path}} to bucket at {{path in bucket}}.", new Object[]{file, pathInBucket}).toString(), exception);
        }
    }

    private void validateSlc(ScriptLanguageContainer slc, FileProvider fileProvider) {
        String fileName = fileProvider.getFileName();
        if (SUPPORTED_SLC_FILE_EXTENSIONS.stream().noneMatch(fileName::endsWith)) {
            throw new IllegalArgumentException(this.wrongFileExtensionErrorMessage(slc, fileName));
        }
        if (slc.getLocalFile() != null && !Files.exists(slc.getLocalFile(), new LinkOption[0])) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-27").message("Local file {{local file}} does not exist", new Object[]{slc.getLocalFile()}).toString());
        }
        if (slc.getUrl() != null && slc.getSha512sum() == null) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-42").message("An URL is specified but sha512sum checksum is missing", new Object[0]).toString());
        }
    }

    private String wrongFileExtensionErrorMessage(ScriptLanguageContainer slc, String fileName) {
        if (slc.getLocalFile() != null) {
            return ExaError.messageBuilder((String)"E-ETC-35").message("File {{file path}} has an unsupported file extension.", new Object[]{slc.getLocalFile()}).mitigation("The following file extensions are supported for SLCs: {{supported file extensions}}.", new Object[]{SUPPORTED_SLC_FILE_EXTENSIONS}).toString();
        }
        return ExaError.messageBuilder((String)"E-ETC-40").message("Filename {{file name}} of URL {{url}} has an unsupported file extension.", new Object[]{fileName, slc.getUrl()}).mitigation("The following file extensions are supported for SLCs: {{supported file extensions}}.", new Object[]{SUPPORTED_SLC_FILE_EXTENSIONS}).toString();
    }

    private void updateSlcConfiguration(ScriptLanguageContainer slc, String fileName) {
        SlcConfiguration configuration = this.slcConfigurator.read();
        configuration.setAlias(slc.getAlias(), this.slcUrlFormatter.format(slc, this.removeExtension(slc, fileName)));
        this.slcConfigurator.write(configuration);
    }

    private String removeExtension(ScriptLanguageContainer slc, String fileName) {
        String extension = SUPPORTED_SLC_FILE_EXTENSIONS.stream().filter(fileName::endsWith).findFirst().orElseThrow(() -> new IllegalArgumentException(this.wrongFileExtensionErrorMessage(slc, fileName)));
        return fileName.substring(0, fileName.length() - extension.length());
    }
}

