/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.exasol.containers.ssh.FileVisitor;
import com.exasol.containers.ssh.Ssh;
import com.exasol.containers.ssh.SshConnection;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ExecResultFactory;

class RemoteExecutor {
    private static final int BUFFER_SIZE = 1024;
    private final byte[] buf = new byte[1024];
    private final Ssh ssh;
    private final Sleeper sleeper;
    private InputStream in;
    private ByteArrayOutputStream err;
    private ByteArrayOutputStream out;

    RemoteExecutor(Ssh ssh) {
        this(ssh, new Sleeper());
    }

    RemoteExecutor(Ssh ssh, Sleeper sleeper) {
        this.ssh = ssh;
        this.sleeper = sleeper;
    }

    Container.ExecResult execute(Charset charset, String ... command) throws IOException {
        SshConnection connection = this.connect(this.ssh, command);
        try {
            while (this.process(connection) == FileVisitor.State.CONTINUE) {
            }
            Container.ExecResult execResult = this.result(connection, charset);
            if (connection != null) {
                connection.close();
            }
            return execResult;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSchException exception) {
                throw new IOException("SSH execution failed", exception);
            }
        }
    }

    SshConnection connect(Ssh ssh, String ... command) throws IOException, JSchException {
        ChannelExec channel = (ChannelExec)ssh.openChannel("exec");
        channel.setCommand(String.join((CharSequence)" ", command));
        this.in = channel.getInputStream();
        this.err = new ByteArrayOutputStream();
        channel.setErrStream((OutputStream)this.err);
        this.out = new ByteArrayOutputStream();
        return new SshConnection((Channel)channel);
    }

    FileVisitor.State process(SshConnection connection) throws IOException {
        int i;
        while (this.in.available() > 0 && (i = this.in.read(this.buf, 0, 1024)) >= 0) {
            this.out.write(this.buf, 0, i);
        }
        if (!connection.channel().isClosed()) {
            this.sleeper.sleep(1000);
            return FileVisitor.State.CONTINUE;
        }
        if (this.in.available() > 0) {
            return FileVisitor.State.CONTINUE;
        }
        return FileVisitor.State.COMPLETED;
    }

    Container.ExecResult result(SshConnection connection, Charset charset) {
        return ExecResultFactory.result(connection.channel().getExitStatus(), this.out.toString(charset), this.err.toString(charset));
    }

    static class Sleeper {
        Sleeper() {
        }

        void sleep(int millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

