/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.exasol.containers.ssh.RemoteExecutor;
import com.exasol.containers.ssh.RemoteFileParser;
import com.exasol.containers.ssh.RemoteFileReader;
import com.exasol.containers.ssh.RemoteFileWriter;
import com.exasol.containers.ssh.Retry;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public class Ssh {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ssh.class);
    private final Session session;
    private Charset charset = StandardCharsets.UTF_8;

    public Ssh(Session session) {
        this.session = session;
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public Ssh withCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Container.ExecResult execute(String ... command) throws IOException {
        return this.execute(this.charset, command);
    }

    public Container.ExecResult execute(Charset charset, String ... command) throws IOException {
        return this.createRemoteExecutor().execute(charset, command);
    }

    public String readRemoteFile(String path) throws IOException, JSchException {
        return this.createRemoteFileReader().read(path);
    }

    public void writeRemoteFile(Path local, String remote) throws IOException, JSchException {
        this.createRemoteFileWriter().write(local, remote);
    }

    public String parseRemoteFile(String path, RemoteFileParser.LineMatcher lineMatcher) throws IOException, JSchException {
        return this.createRemoteFileParser().findMatch(path, lineMatcher);
    }

    public Charset getCharset() {
        return this.charset;
    }

    RemoteExecutor createRemoteExecutor() {
        return new RemoteExecutor(this);
    }

    RemoteFileReader createRemoteFileReader() {
        return new RemoteFileReader(this);
    }

    RemoteFileParser createRemoteFileParser() {
        return new RemoteFileParser(this);
    }

    RemoteFileWriter createRemoteFileWriter() {
        return new RemoteFileWriter(this);
    }

    Channel openChannel(String type) throws JSchException {
        if (!this.session.isConnected()) {
            this.connectWithRetry();
        }
        return this.session.openChannel(type);
    }

    private void connectWithRetry() throws JSchException {
        Duration timeout = Duration.ofSeconds(60L);
        LOGGER.info("Trying to open SSH channel to docker container with timeout {}", (Object)timeout);
        Retry<JSchException> retry = new Retry<JSchException>(JSchException.class, timeout);
        retry.retry(() -> ((Session)this.session).connect());
        LOGGER.info("SSH channel successfully opened");
    }
}

