/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.drivers;

import com.exasol.drivers.DatabaseDriver;
import java.nio.file.Path;

public class JdbcDriver
implements DatabaseDriver {
    private static final long serialVersionUID = 8538768853929154698L;
    private final String name;
    private final String prefix;
    private final String sourcePath;
    private final String mainClass;
    private final boolean securityManagerEnabled;

    private JdbcDriver(Builder builder) {
        this.name = builder.name;
        this.prefix = builder.prefix;
        this.sourcePath = builder.localPath == null ? null : builder.localPath.toString();
        this.mainClass = builder.mainClass;
        this.securityManagerEnabled = builder.securityManagerEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    public boolean hasSourceFile() {
        return this.sourcePath != null;
    }

    @Override
    public Path getSourcePath() {
        return Path.of(this.sourcePath, new String[0]);
    }

    @Override
    public String getFileName() {
        return this.getSourcePath().getFileName().toString();
    }

    public boolean isSecurityManagerEnabled() {
        return this.securityManagerEnabled;
    }

    public String toString() {
        return "JDBC driver \"" + this.name + "\" (" + this.mainClass + ")" + (String)(this.hasSourceFile() ? ", source: \"" + this.sourcePath + "\"" : "");
    }

    @Override
    public String getManifest() {
        return "DRIVERNAME=" + this.name + "\nJAR=" + this.getDriverFilename() + "\nDRIVERMAIN=" + this.mainClass + "\nPREFIX=" + this.prefix + "\nNOSECURITY=" + (this.securityManagerEnabled ? "NO" : "YES") + "\nFETCHSIZE=100000\nINSERTSIZE=-1\n";
    }

    private String getDriverFilename() {
        return Path.of(this.sourcePath, new String[0]).getFileName().toString();
    }

    public static class Builder {
        private final String name;
        private String prefix;
        private Path localPath;
        private String mainClass;
        private boolean securityManagerEnabled = true;

        public Builder(String name) {
            this.name = name;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder sourceFile(Path sourcePath) {
            this.localPath = sourcePath;
            return this;
        }

        public Builder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Builder enableSecurityManager(boolean enable) {
            this.securityManagerEnabled = enable;
            return this;
        }

        public JdbcDriver build() {
            this.validate();
            return new JdbcDriver(this);
        }

        private void validate() {
            if (this.name == null || !this.name.matches("[a-zA-Z]\\w+")) {
                throw new IllegalStateException("Empty or illegal driver name (" + this.name + ") trying to build JDBC driver. The driver name must start with a letter followed by zero or more alphanumeric characters or underscores.");
            }
            if (this.prefix == null || !this.prefix.startsWith("jdbc:")) {
                throw new IllegalStateException("Empty or illegal JDBC URL prefix (" + this.prefix + ") trying to build JDBC driver. The prefix must start with \"jdbc:\".Please consult the driver's manual for the driver-specific JDBC URL syntax.");
            }
            if (this.mainClass == null || !this.mainClass.matches("[a-zA-Z]\\w{0,254}(?:.[a-zA-Z]\\w{0,254}){0,10}")) {
                throw new IllegalStateException("Empty or illegal main class (" + this.mainClass + ") trying to build JDBC driver. Please consult the driver's manual, check the correct spelling and provide the main class name via the mainClass() method.");
            }
        }
    }
}

