/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.clusterlogs;

import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.bucketfs.monitor.LineCountState;
import com.exasol.bucketfs.monitor.TimestampState;
import com.exasol.clusterlogs.LogEntryPatternVerifier;
import com.exasol.clusterlogs.TimestampLogEntryPatternVerifier;
import com.exasol.containers.ExasolContainer;
import com.exasol.containers.ExasolDockerImageReference;
import com.exasol.containers.ssh.SshException;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public class LogPatternDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogPatternDetector.class);
    private ExasolContainer<? extends ExasolContainer<?>> container;
    private String logPath;
    private String pattern;
    private String logNamePattern;
    private LogEntryPatternVerifier logEntryVerifier = LogEntryPatternVerifier.ALWAYS_TRUE;
    private long afterLine = 0L;

    public static Builder builder() {
        return new Builder();
    }

    private LogPatternDetector() {
    }

    public boolean isPatternPresent() throws IOException, InterruptedException, SshException {
        Container.ExecResult result = this.container.execInContainer(new String[]{"find", this.logPath, "-name", this.logNamePattern, "-exec", "awk", this.awkCommand(this.afterLine, this.pattern.replace("/", "\\/")), "{}", "+"});
        if (result.getExitCode() == 0) {
            return this.logEntryVerifier.isLogMessageFound(result.getStdout());
        }
        return false;
    }

    private String awkCommand(long afterLine, String regex) {
        return "(NR>" + afterLine + ")&&/" + regex + "/{a=$0}END{print a}";
    }

    public String describe() {
        return "Scanning for log message pattern \"" + this.pattern + "\" in \"" + this.logPath + "/" + this.logNamePattern + "\", using " + String.valueOf(this.logEntryVerifier) + ".";
    }

    public String getActualLog() {
        try {
            Container.ExecResult result = this.container.execInContainer(new String[]{"find", this.logPath, "-name", this.logNamePattern, "-exec", "cat", "{}", "+"});
            return result.getStdout();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("InterruptedException when reading log file content", exception);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder((String)"F-ETC-6").message("Exception reading content of file(s) {{logPath}}/{{logNamePattern}}", new Object[]{this.logPath, this.logNamePattern}).toString(), exception);
        }
    }

    static class Builder {
        private final LogPatternDetector detector = new LogPatternDetector();

        Builder() {
        }

        public Builder container(ExasolContainer<? extends ExasolContainer<?>> value) {
            this.detector.container = value;
            return this;
        }

        public Builder logPath(String value) {
            this.detector.logPath = value;
            return this;
        }

        public Builder pattern(String value) {
            this.detector.pattern = value;
            return this;
        }

        public Builder logNamePattern(String value) {
            this.detector.logNamePattern = value;
            return this;
        }

        public Builder forState(BucketFsMonitor.State state) {
            if (state instanceof LineCountState) {
                return this.afterLine(((LineCountState)state).getLineNumber());
            }
            if (state instanceof TimestampState) {
                return this.logEntryVerifier(new TimestampLogEntryPatternVerifier(state, this.getTimezone()));
            }
            throw new IllegalArgumentException("Unsupported class " + String.valueOf(state.getClass()) + " of state");
        }

        private TimeZone getTimezone() {
            ExasolDockerImageReference image = this.detector.container.getDockerImageReference();
            if (image.hasMajor() && image.getMajor() < 8) {
                return this.detector.container.getClusterConfiguration().getTimeZone();
            }
            return TimeZone.getTimeZone("UTC");
        }

        public Builder logEntryVerifier(LogEntryPatternVerifier value) {
            this.detector.logEntryVerifier = value;
            return this;
        }

        public Builder afterLine(long value) {
            this.detector.afterLine = value;
            return this;
        }

        public LogPatternDetector build() {
            LOGGER.trace("Created log detector that scans for \"{}\" in \"{}/{}\" after line {} with verifier {}", new Object[]{this.detector.pattern, this.detector.logPath, this.detector.logNamePattern, this.detector.afterLine, this.detector.logEntryVerifier});
            return this.detector;
        }
    }
}

