/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.slc;

import com.exasol.errorreporting.ExaError;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

class SlcConfiguration {
    private final Map<String, String> entries;

    private SlcConfiguration(Map<String, String> entries) {
        this.entries = entries;
    }

    static SlcConfiguration parse(String value) {
        Map entries = Arrays.stream(value.split(" ")).filter(Predicate.not(String::isBlank)).map(SlcConfiguration::parseEntry).collect(SlcConfiguration.toLinkedHashMap());
        return new SlcConfiguration(entries);
    }

    private static Collector<List<String>, ?, LinkedHashMap<String, String>> toLinkedHashMap() {
        return Collectors.toMap(entry -> (String)entry.get(0), entry -> (String)entry.get(1), SlcConfiguration::failForDuplicateKeys, LinkedHashMap::new);
    }

    private static String failForDuplicateKeys(String a, String b) {
        throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-31").message("Found two entries with the same key: {{value 1}}, {{value 2}}", new Object[]{a, b}).toString());
    }

    private static List<String> parseEntry(String entry) {
        int index = entry.indexOf("=");
        if (index == -1) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-28").message("Invalid entry in SLC configuration: {{entry}}", new Object[]{entry}).toString());
        }
        String key = entry.substring(0, index).trim();
        if (key.isEmpty()) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-29").message("Invalid key in SLC configuration: {{entry}}", new Object[]{entry}).toString());
        }
        String value = entry.substring(index + 1).trim();
        if (value.isEmpty()) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-30").message("Invalid value in SLC configuration: {{entry}}", new Object[]{entry}).toString());
        }
        return List.of(key, value);
    }

    String format() {
        return this.entries.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(" "));
    }

    void setAlias(String alias, String configuration) {
        this.entries.put(alias.trim(), configuration.trim());
    }
}

