/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exaoperation;

import com.exasol.containers.ExasolContainer;
import com.exasol.containers.ssh.SshException;
import com.exasol.exaoperation.ExaOperation;
import com.exasol.exaoperation.ExaOperationEmulatorException;
import com.exasol.exaoperation.plugin.Plugin;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public class ExaOperationEmulator
implements ExaOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExaOperationEmulator.class);
    private final ExasolContainer<? extends ExasolContainer<?>> container;
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();

    public ExaOperationEmulator(ExasolContainer<? extends ExasolContainer<?>> container) {
        this.container = container;
    }

    private Container.ExecResult execInContainer(String description, String ... command) {
        try {
            Container.ExecResult result = this.container.execInContainer(command);
            if (result.getExitCode() != 0) {
                throw new ExaOperationEmulatorException(description + " in container not successful: " + result.getStderr());
            }
            return result;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            throw new ExaOperationEmulatorException(description + " in container got interrupted.");
        }
        catch (SshException | IOException | UnsupportedOperationException exception) {
            throw new ExaOperationEmulatorException(description + " in container failed.", exception);
        }
    }

    @Override
    public Plugin installPluginPackage(Path sourcePath) {
        if (sourcePath.toFile().exists()) {
            try {
                LOGGER.debug("Installing plug-in \"{}\".", (Object)sourcePath);
                Plugin plugin = new Plugin(sourcePath, (Container<? extends Container<?>>)this.container);
                if (this.hasPlugin(plugin.getName())) {
                    throw new ExaOperationEmulatorException("Plugin \"" + plugin.getName() + "\" is already installed.");
                }
                String tmpDirectory = this.createTempDirectory();
                this.copyPackageToContainer(plugin, tmpDirectory + "/" + plugin.getFileName());
                this.extractPluginPackage(plugin, tmpDirectory);
                this.registerPlugin(plugin);
                this.removeTempDirectory(tmpDirectory);
                return plugin;
            }
            catch (ExaOperationEmulatorException exception) {
                throw new ExaOperationEmulatorException("Unable to install plug-in.", exception);
            }
        }
        throw new IllegalArgumentException("Plug-in package \"" + String.valueOf(sourcePath) + "\" does not exist.");
    }

    private String createTempDirectory() {
        Container.ExecResult result = this.execInContainer("Create temp directory for plugin", "/bin/mktemp", "--directory", "--tmpdir=/tmp", "tmp.XXXXXXXX-plugin");
        return result.getStdout().trim();
    }

    private void removeTempDirectory(String tempDirectory) {
        if (!Pattern.compile("/tmp/.+-plugin").matcher(tempDirectory).matches()) {
            throw new ExaOperationEmulatorException("\"" + tempDirectory + "\" does not meet our naming convention. Refusing to delete.");
        }
        this.execInContainer("Remove plugin temp directory", "/bin/rm", "-rf", tempDirectory);
    }

    private void copyPackageToContainer(Plugin plugin, String targetPath) throws SshException {
        this.container.copyFileToContainer(plugin.getSourcePath(), targetPath);
    }

    private void extractPluginPackage(Plugin plugin, String tempDirectory) {
        String from = tempDirectory + "/" + plugin.getFileName();
        String to = tempDirectory + "/";
        LOGGER.debug("Extracting EXAoperation plug-in from \"{}\" to \"{}\".", (Object)from, (Object)to);
        this.execInContainer("Extract plugin package " + String.valueOf(plugin.getSourcePath().getFileName()), "tar", "xf", from, "-C", to);
        this.extractPluginPayload(plugin, tempDirectory);
    }

    private void extractPluginPayload(Plugin plugin, String tempDirectory) {
        String from = this.assembleInnerPath(plugin, tempDirectory);
        String to = "/";
        LOGGER.debug("Extracting the plug-in's inner archive \"{}\" to \"{}\".", (Object)from, (Object)"/");
        this.execInContainer("Unpack plug-in payload (inner TAR archive)", "tar", "xzf", from, "-C", "/");
    }

    private String assembleInnerPath(Plugin plugin, String tempDirectory) {
        return tempDirectory + "/Plugin." + plugin.getName() + ".tar.gz";
    }

    private void registerPlugin(Plugin plugin) {
        this.plugins.put(plugin.getName(), plugin);
    }

    @Override
    public boolean hasPlugin(String pluginName) {
        return this.plugins.containsKey(pluginName);
    }

    @Override
    public Plugin getPlugin(String pluginName) {
        if (this.hasPlugin(pluginName)) {
            return this.plugins.get(pluginName);
        }
        throw new IllegalArgumentException("Unable to get control object for plug-in named \"" + pluginName + "\". Choose one of: " + String.join((CharSequence)", ", this.getPluginNames()));
    }

    @Override
    public List<String> getPluginNames() {
        return new ArrayList<String>(this.plugins.keySet());
    }
}

