/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.containers.ContainerTimeService;
import com.exasol.containers.ExasolContainerException;
import com.exasol.errorreporting.ExaError;
import org.testcontainers.containers.ContainerLaunchException;

public class ContainerSynchronizationVerifier {
    private final ContainerTimeService timeService;

    public static ContainerSynchronizationVerifier create(ContainerTimeService timeService) {
        return new ContainerSynchronizationVerifier(timeService);
    }

    private ContainerSynchronizationVerifier(ContainerTimeService timeService) {
        this.timeService = timeService;
    }

    public void verifyClocksInSync() throws ExasolContainerException {
        long offset = System.currentTimeMillis() - this.timeService.getMillisSinceEpochUtc();
        if (Math.abs(offset) > 2000L) {
            throw new ContainerLaunchException(ExaError.messageBuilder((String)"E-ETC-17").message("The clock of the Exasol VM is offset by up to {{offset}} ms in relation to the clock of  the host running test containers. Note that the measured offset has a limited  precision caused by the latency of querying the time in the container, so the actual offset might be a couple of milliseconds better than reported here. The maximum allowed offset in any direction is {{maximum-offset}} ms.", new Object[0]).parameter("offset", (Object)offset, "actual clock offset in milliseconds").parameter("maximum-offset", (Object)2000, "maximum allowed offest in milliseconds").mitigation("Use a time synchronization tool like NTP to ensure sychronized clocks.", new Object[0]).toString());
        }
    }
}

