/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.bucketfs.Bucket;
import com.exasol.bucketfs.testcontainers.LogBasedBucketFsMonitor;
import com.exasol.bucketfs.testcontainers.TestcontainerBucketFactory;
import com.exasol.clusterlogs.LogPatternDetectorFactory;
import com.exasol.config.ClusterConfiguration;
import com.exasol.containers.ContainerFileOperations;
import com.exasol.containers.ContainerSynchronizationVerifier;
import com.exasol.containers.ContainerTimeService;
import com.exasol.containers.DBVersionChecker;
import com.exasol.containers.DockerImageReferenceFactory;
import com.exasol.containers.ExasolContainerConstants;
import com.exasol.containers.ExasolContainerInitializationException;
import com.exasol.containers.ExasolDockerImageReference;
import com.exasol.containers.ExasolService;
import com.exasol.containers.ExitType;
import com.exasol.containers.HostIpDetector;
import com.exasol.containers.PortDetectionException;
import com.exasol.containers.UncheckedSqlException;
import com.exasol.containers.slc.ScriptLanguageContainer;
import com.exasol.containers.slc.ScriptLanguageContainerInstaller;
import com.exasol.containers.ssh.DockerAccess;
import com.exasol.containers.ssh.SessionBuilder;
import com.exasol.containers.ssh.SshException;
import com.exasol.containers.ssh.SshKeys;
import com.exasol.containers.status.ContainerStatus;
import com.exasol.containers.status.ContainerStatusCache;
import com.exasol.containers.status.ServiceStatus;
import com.exasol.containers.tls.CertificateProvider;
import com.exasol.containers.wait.strategy.BucketFsWaitStrategy;
import com.exasol.containers.wait.strategy.UdfContainerWaitStrategy;
import com.exasol.containers.workarounds.LogRotationWorkaround;
import com.exasol.containers.workarounds.Workaround;
import com.exasol.containers.workarounds.WorkaroundException;
import com.exasol.containers.workarounds.WorkaroundManager;
import com.exasol.database.DatabaseService;
import com.exasol.database.DatabaseServiceFactory;
import com.exasol.dbcleaner.ExasolDatabaseCleaner;
import com.exasol.drivers.ExasolDriverManager;
import com.exasol.errorreporting.ExaError;
import com.exasol.exaconf.ConfigurationParser;
import com.exasol.exaoperation.ExaOperation;
import com.exasol.exaoperation.ExaOperationEmulator;
import com.exasol.support.SupportInformationRetriever;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.TestcontainersConfiguration;

public class ExasolContainer<T extends ExasolContainer<T>>
extends JdbcDatabaseContainer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExasolContainer.class);
    private static final long CONNECTION_TEST_RETRY_INTERVAL_MILLISECONDS = 500L;
    private ClusterConfiguration clusterConfiguration = null;
    private String username = "SYS";
    private String password = "exasol";
    private final LogPatternDetectorFactory detectorFactory;
    private Set<ExasolService> requiredServices = Set.of(ExasolService.values());
    private final ExaOperation exaOperation;
    private final CertificateProvider certificateProvider;
    private TimeZone timeZone;
    private boolean reused = false;
    private final ExasolDockerImageReference dockerImageReference;
    private boolean portAutodetectFailed = false;
    private Duration connectionWaitTimeout = Duration.ofSeconds(250L);
    private Duration jdbcLoginTimeout = Duration.ofSeconds(10L);
    private ExasolDriverManager driverManager = null;
    private final ContainerStatusCache statusCache = new ContainerStatusCache(ExasolContainerConstants.CACHE_DIRECTORY);
    private ContainerStatus status = null;
    private SupportInformationRetriever supportInformationRetriever = null;
    private boolean errorWhileWaitingForServices = false;
    private SQLException lastConnectionException = null;
    private Path temporaryCredentialsDirectory = ExasolContainerConstants.CACHE_DIRECTORY;
    private DockerAccess dockerAccess = null;
    private final List<ScriptLanguageContainer> scriptLanguageContainers = new ArrayList<ScriptLanguageContainer>();

    public ExasolContainer(String dockerImageName) {
        this(dockerImageName, true);
    }

    public ExasolContainer(String dockerImageName, boolean allowImageOverride) {
        this(DockerImageReferenceFactory.parseOverridable(dockerImageName, allowImageOverride));
        this.supportInformationRetriever = new SupportInformationRetriever((Container<? extends Container<?>>)this);
    }

    private ExasolContainer(ExasolDockerImageReference dockerImageReference) {
        super(DockerImageName.parse((String)dockerImageReference.toString()));
        this.dockerImageReference = dockerImageReference;
        this.detectorFactory = new LogPatternDetectorFactory(this);
        this.exaOperation = new ExaOperationEmulator(this);
        ContainerFileOperations containerFileOperations = new ContainerFileOperations(this);
        this.certificateProvider = new CertificateProvider(this::getOptionalClusterConfiguration, containerFileOperations);
        try {
            this.addExposedPorts(new int[]{this.getDefaultInternalDatabasePort()});
            this.addExposedPorts(new int[]{this.getDefaultInternalBucketfsPort()});
            this.addExposedPorts(new int[]{this.getDefaultInternalRpcPort()});
            this.addExposedPorts(new int[]{20002});
        }
        catch (PortDetectionException exception) {
            LOGGER.warn("Failed to detect internal ports.", (Throwable)exception);
            this.portAutodetectFailed = true;
        }
    }

    public ExasolContainer() {
        this("2025.1.3");
    }

    public ExasolDockerImageReference getDockerImageReference() {
        return this.dockerImageReference;
    }

    protected void configure() {
        this.configureExposedPorts();
        this.configurePrivilegedMode();
        this.dockerAccess = this.createDockerAccess();
        this.copyAuthorizedKeys(this.dockerAccess);
        super.configure();
    }

    private void configureExposedPorts() {
        if (this.portAutodetectFailed) {
            if (this.getExposedPorts().isEmpty()) {
                throw new IllegalArgumentException("Could not detect internal ports for custom image. Please specify the port explicitly using withExposedPorts().");
            }
            LOGGER.warn("Could not detect internal ports for custom image. Don't forget to expose the database and BucketFs ports yourself.");
        }
        LOGGER.debug("Exposing ports: {}", (Object)this.getExposedPorts());
    }

    private void configurePrivilegedMode() {
        this.setPrivilegedMode(true);
    }

    private static UnsupportedOperationException getTimeoutNotSupportedException() {
        throw new UnsupportedOperationException("The Exasol testcontainer do not support this configuration. Use withJdbcConnectionTimeout instead.");
    }

    public int getDefaultInternalDatabasePort() {
        if (this.dockerImageReference.hasMajor()) {
            if (this.dockerImageReference.getMajor() >= 7) {
                return 8563;
            }
            return 8888;
        }
        throw new PortDetectionException("database");
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Set.of(this.getFirstMappedDatabasePort());
    }

    private int getFirstDatabasePort() {
        return this.getClusterConfiguration().getDatabaseServiceConfiguration(0).getPort();
    }

    public String getDriverClassName() {
        return "com.exasol.jdbc.EXADriver";
    }

    public String getJdbcUrl() {
        Optional<String> fingerprint = this.getTlsCertificateFingerprint();
        if (this.clusterConfiguration != null && this.getDockerImageReference().getMajor() >= 7 && fingerprint.isPresent()) {
            return this.getJdbcUrlWithFingerprint(fingerprint.get());
        }
        return this.getJdbcUrlWithoutFingerprint();
    }

    private String getJdbcUrlWithFingerprint(String fingerprint) {
        return "jdbc:exa:" + this.getHost() + ":" + this.getFirstMappedDatabasePort() + ";validateservercertificate=1;fingerprint=" + fingerprint + ";" + this.getCommonJdbcParameters();
    }

    private String getJdbcUrlWithoutFingerprint() {
        return "jdbc:exa:" + this.getHost() + ":" + this.getFirstMappedDatabasePort() + ";validateservercertificate=0;" + this.getCommonJdbcParameters();
    }

    private String getCommonJdbcParameters() {
        if (this.jdbcLoginTimeout != null) {
            return String.format("logintimeout=%d;", this.jdbcLoginTimeout.toMillis());
        }
        return "";
    }

    public String getRpcUrl() {
        return "https://" + this.getHost() + ":" + this.getMappedPort(this.getDefaultInternalRpcPort()) + "/jrpc";
    }

    public Integer getFirstMappedDatabasePort() {
        return this.getMappedPort(this.getFirstDatabasePort());
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getExaConnectionAddress() {
        return this.getHost() + ":" + this.getFirstMappedDatabasePort();
    }

    public LogPatternDetectorFactory getLogPatternDetectorFactory() {
        return this.detectorFactory;
    }

    public boolean isReused() {
        return this.reused;
    }

    public Connection createConnectionForUser(String user, String password) throws UncheckedSqlException {
        Driver driver = this.getJdbcDriverInstance();
        Properties info = new Properties();
        info.put("user", user);
        info.put("password", password);
        String url = this.constructUrlForConnection("");
        try {
            return driver.connect(url, info);
        }
        catch (SQLException exception) {
            throw new UncheckedSqlException(ExaError.messageBuilder((String)"E-ETC-26").message("Failed to connect to {{jdbc url}}: {{error message}}", new Object[]{url, exception.getMessage()}).toString(), exception);
        }
    }

    public Connection createConnection() throws UncheckedSqlException {
        return this.createConnectionForUser(this.getUsername(), this.getPassword());
    }

    protected String getTestQueryString() {
        return "SELECT 1";
    }

    public T withUsername(String username) {
        this.username = username;
        return (T)((Object)((ExasolContainer)this.self()));
    }

    public T withPassword(String password) {
        this.password = password;
        return (T)((Object)((ExasolContainer)this.self()));
    }

    public T withReuse(boolean reuse) {
        ExasolDockerImageReference image = this.getDockerImageReference();
        if (!image.hasMajor()) {
            LOGGER.info("Docker instance reuse requested, but could not detect Exasol major version of docker image {}. Using normal mode instead.", (Object)image);
            return (T)((Object)((ExasolContainer)super.withReuse(false)));
        }
        if (image.getMajor() < 7) {
            LOGGER.info("Docker instance reuse requested, but this is not supported by Exasol version below 7. Using normal mode instead.");
            return (T)((Object)((ExasolContainer)super.withReuse(false)));
        }
        return (T)((Object)((ExasolContainer)super.withReuse(reuse)));
    }

    public T withRequiredServices(ExasolService ... optionalServices) {
        HashSet<ExasolService> services = new HashSet<ExasolService>();
        this.addMandatoryServices(services);
        services.addAll(Arrays.asList(optionalServices));
        this.requiredServices = services;
        return (T)((Object)((ExasolContainer)this.self()));
    }

    public T withTemporaryCredentialsDirectory(Path path) {
        this.temporaryCredentialsDirectory = path;
        return (T)((Object)((ExasolContainer)this.self()));
    }

    public T withScriptLanguageContainer(ScriptLanguageContainer scriptLanguageContainer) {
        this.scriptLanguageContainers.add(scriptLanguageContainer);
        return (T)((Object)((ExasolContainer)this.self()));
    }

    private void addMandatoryServices(HashSet<ExasolService> services) {
        services.add(ExasolService.JDBC);
    }

    public synchronized ClusterConfiguration getClusterConfiguration() {
        if (this.clusterConfiguration == null) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETC-25").message("Tried to access Exasol cluster configuration before it was read from the container.", new Object[0]).mitigation("Wait until startup is complete.", new Object[0]).toString());
        }
        return this.clusterConfiguration;
    }

    private Optional<ClusterConfiguration> getOptionalClusterConfiguration() {
        return Optional.ofNullable(this.clusterConfiguration);
    }

    public Bucket getBucket(String bucketFsName, String bucketName) {
        return this.getBucket(bucketFsName, bucketName, LogBasedBucketFsMonitor.FilterStrategy.TIME_STAMP);
    }

    public Bucket getBucket(String bucketFsName, String bucketName, LogBasedBucketFsMonitor.FilterStrategy filterStrategy) {
        TestcontainerBucketFactory.Builder builder = TestcontainerBucketFactory.builder().host(this.getHost()).clusterConfiguration(this.getClusterConfiguration()).portMappings(this.getPortMappings()).detectorFactory(this.detectorFactory).filterStrategy(filterStrategy);
        this.getTlsCertificate().ifPresent(builder::certificate);
        return builder.build().getBucket(bucketFsName, bucketName);
    }

    private Map<Integer, Integer> getPortMappings() {
        HashMap<Integer, Integer> portMappings = new HashMap<Integer, Integer>();
        Iterator iterator = this.getExposedPorts().iterator();
        while (iterator.hasNext()) {
            int exposedPort = (Integer)iterator.next();
            portMappings.put(exposedPort, this.getMappedPort(exposedPort));
        }
        return portMappings;
    }

    public Bucket getDefaultBucket() {
        return this.getBucket("bfsdefault", "default");
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        String containerId = containerInfo.getId();
        if (this.statusCache.isCacheAvailable(containerId)) {
            this.status = this.statusCache.read(containerId);
        } else {
            LOGGER.debug("No status cache found for container \"{}\". Creating fresh status.", (Object)containerId);
            this.status = ContainerStatus.create(containerId);
        }
        super.containerIsStarting(containerInfo);
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        this.reused = reused;
        super.containerIsStarting(containerInfo, reused);
    }

    public void start() {
        this.checkScriptLanguageContainersRequiresExposedBucketFSPort();
        super.start();
        this.checkClusterConfigurationForMinimumSupportedDBVersion();
        ContainerSynchronizationVerifier.create(ContainerTimeService.create(this)).verifyClocksInSync();
    }

    protected void waitUntilContainerStarted() {
        try {
            this.waitUntilClusterConfigurationAvailable();
            this.waitUntilStatementCanBeExecuted();
            this.waitForBucketFs();
            this.waitForUdfContainer();
            LOGGER.info("Exasol container started after waiting for the following services to become available: {}", this.requiredServices);
        }
        catch (Exception exception) {
            this.errorWhileWaitingForServices = true;
            throw exception;
        }
    }

    protected void waitForBucketFs() {
        if (this.isServiceReady(ExasolService.BUCKETFS)) {
            LOGGER.debug("BucketFS marked running in container status cache. Skipping startup monitoring.");
        } else if (this.requiredServices.contains((Object)ExasolService.BUCKETFS)) {
            this.status.setServiceStatus(ExasolService.BUCKETFS, ServiceStatus.NOT_READY);
            new BucketFsWaitStrategy(this.detectorFactory).waitUntilReady((WaitStrategyTarget)this);
            this.status.setServiceStatus(ExasolService.BUCKETFS, ServiceStatus.READY);
        } else {
            this.status.setServiceStatus(ExasolService.BUCKETFS, ServiceStatus.NOT_CHECKED);
        }
    }

    protected void waitForUdfContainer() {
        if (this.isServiceReady(ExasolService.UDF)) {
            LOGGER.debug("UDF Container marked running in container status cache. Skipping startup monitoring.");
            return;
        }
        if (!this.requiredServices.contains((Object)ExasolService.UDF)) {
            this.status.setServiceStatus(ExasolService.UDF, ServiceStatus.NOT_CHECKED);
            return;
        }
        if (this.languageContainersExtracted()) {
            this.status.setServiceStatus(ExasolService.UDF, ServiceStatus.READY);
            return;
        }
        this.status.setServiceStatus(ExasolService.UDF, ServiceStatus.NOT_READY);
        new UdfContainerWaitStrategy(this.detectorFactory).waitUntilReady((WaitStrategyTarget)this);
        this.status.setServiceStatus(ExasolService.UDF, ServiceStatus.READY);
    }

    private boolean languageContainersExtracted() {
        return this.dockerImageReference.hasMajor() && this.dockerImageReference.getMajor() >= 8;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarted(containerInfo, reused);
        this.applyWorkarounds();
        this.cleanUpDatabaseIfNecessary();
        this.installSlcIfNecessary();
        this.cacheContainerStatus();
    }

    private void applyWorkarounds() {
        LogRotationWorkaround logRotationWorkaround = new LogRotationWorkaround(this);
        try {
            Set<String> previouslyAppliedWorkarounds = this.status.getAppliedWorkarounds();
            WorkaroundManager manager = WorkaroundManager.create(previouslyAppliedWorkarounds, logRotationWorkaround);
            Set<String> appliedWorkaroundNames = manager.applyWorkarounds().stream().map(Workaround::getName).collect(Collectors.toUnmodifiableSet());
            this.status.addAllAppliedWorkarounds(appliedWorkaroundNames);
        }
        catch (WorkaroundException exception) {
            throw new ExasolContainerInitializationException("Failed to apply necessary workarounds", exception);
        }
    }

    private void cleanUpDatabaseIfNecessary() {
        if (this.reused) {
            this.purgeDatabase();
        }
    }

    private void installSlcIfNecessary() {
        if (this.scriptLanguageContainers.isEmpty()) {
            return;
        }
        ScriptLanguageContainerInstaller slcManager = ScriptLanguageContainerInstaller.create(this);
        for (ScriptLanguageContainer slc : this.scriptLanguageContainers) {
            if (this.status.isInstalled(slc)) {
                LOGGER.debug("SLC {} already installed. Skipping installation.", (Object)slc);
                continue;
            }
            slcManager.install(slc);
            this.status.addInstalledSlc(slc);
        }
    }

    public void purgeDatabase() {
        LOGGER.info("Purging database for a clean setup");
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            new ExasolDatabaseCleaner(statement).cleanDatabase();
        }
        catch (SQLException exception) {
            throw new ExasolContainerInitializationException("Failed to purge database", exception);
        }
    }

    private void cacheContainerStatus() {
        this.statusCache.write(this.getContainerId(), this.status);
    }

    protected void waitUntilClusterConfigurationAvailable() {
        if (!this.reused) {
            Duration timeout = Duration.ofSeconds(60L);
            Instant start = Instant.now();
            LOGGER.trace("Waiting {} for cluster configuration to become available.", (Object)timeout);
            WaitStrategy strategy = new LogMessageWaitStrategy().withRegEx(".*exadt:: setting hostname.*").withStartupTimeout(timeout);
            strategy.waitUntilReady((WaitStrategyTarget)this);
            LOGGER.trace("Cluster configuration available after {}.", (Object)Duration.between(start, Instant.now()));
        }
        this.clusterConfigurationIsAvailable();
    }

    private void clusterConfigurationIsAvailable() {
        this.clusterConfiguration = this.readClusterConfiguration();
        this.timeZone = this.clusterConfiguration.getTimeZone();
        if (this.timeZone == null) {
            throw new IllegalStateException("Unable to get timezone from cluster configuration. Log entry detection does not work without TZ.");
        }
    }

    private void checkClusterConfigurationForMinimumSupportedDBVersion() {
        String dbVersion = this.clusterConfiguration.getDBVersion();
        DBVersionChecker.minimumSupportedDbVersionCheck(dbVersion);
    }

    private void checkScriptLanguageContainersRequiresExposedBucketFSPort() {
        int bucketfsPort = this.getDefaultInternalBucketfsPort();
        if (!this.scriptLanguageContainers.isEmpty() && !this.getExposedPorts().contains(bucketfsPort)) {
            throw new ContainerLaunchException(ExaError.messageBuilder((String)"E-ETC-43").message("Installation of ScriptLanguageContainer requires the BucketFS port {{port}} to be exposed", new Object[]{bucketfsPort}).toString());
        }
    }

    public void copyFileToContainer(Path local, String remote) throws SshException {
        if (this.dockerAccess.supportsDockerExec()) {
            super.copyFileToContainer(MountableFile.forHostPath((Path)local), remote);
            return;
        }
        try {
            this.dockerAccess.getSsh().writeRemoteFile(local, remote);
        }
        catch (JSchException | IOException exception) {
            throw new SshException(ExaError.messageBuilder((String)"E-ETC-21").message("Failed to copy local file {{local}} to target path {{remote}} in container.", new Object[]{local, remote}).toString(), (Exception)exception);
        }
    }

    private ClusterConfiguration readClusterConfiguration() {
        try {
            Container.ExecResult result = this.execInContainer(new String[]{"cat", "/exa/etc/EXAConf"});
            String exaconf = result.getStdout();
            return new ConfigurationParser(exaconf).parse();
        }
        catch (SshException | IOException | UnsupportedOperationException exception) {
            throw new ExasolContainerInitializationException("Unable to read cluster configuration from \"/exa/etc/EXAConf\".", exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new ExasolContainerInitializationException("Caught interrupt trying to read cluster configuration from \"/exa/etc/EXAConf\".", exception);
        }
    }

    private void waitUntilStatementCanBeExecuted() {
        LOGGER.trace("Waiting {} for JDBC connection", (Object)this.connectionWaitTimeout);
        this.sleepBeforeNextConnectionAttempt();
        Instant before = Instant.now();
        Instant expiry = before.plus(this.connectionWaitTimeout);
        while (Instant.now().isBefore(expiry)) {
            if (!this.isConnectionAvailable()) continue;
            LOGGER.trace("Connection succeeded after {}", (Object)Duration.between(before, Instant.now()));
            return;
        }
        Duration timeoutAfter = Duration.between(before, Instant.now());
        throw new ContainerLaunchException(ExaError.messageBuilder((String)"F-ETC-5").message("Exasol container start-up timed out trying connection to {{url}} using query {{query}} after {{after}} seconds. Last connection exception was: {{exception}}", new Object[0]).parameter("url", (Object)this.getJdbcUrl(), "JDBC URL of the connection to the Exasol Testcontainer").parameter("query", (Object)this.getTestQueryString(), "Query used to test the connection").parameter("after", (Object)timeoutAfter.toSeconds()).parameter("exception", (Object)(this.lastConnectionException == null ? "none" : this.lastConnectionException.getMessage()), "exception thrown on last connection attempt").toString(), (Throwable)this.lastConnectionException);
    }

    private void sleepBeforeNextConnectionAttempt() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ContainerLaunchException("Container start-up wait was interrupted", (Throwable)interruptedException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConnectionAvailable() {
        try (Connection connection = this.createConnection("");
             Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery(this.getTestQueryString());){
            if (!result.next()) throw new ContainerLaunchException("Startup check query failed. Exasol container start-up failed.");
            boolean bl = true;
            return bl;
        }
        catch (JdbcDatabaseContainer.NoDriverFoundException exception) {
            throw new ContainerLaunchException(ExaError.messageBuilder((String)"E-ETC-24").message("Unable to determine start status of container, because the referenced JDBC driver was not found: {{cause}}", new Object[]{exception.getMessage()}).toString(), (Throwable)exception);
        }
        catch (SQLException exception) {
            this.lastConnectionException = exception;
            this.sleepBeforeNextConnectionAttempt();
            return false;
        }
    }

    public String getDockerNetworkInternalIpAddress() {
        Network thisNetwork = this.getNetwork();
        if (thisNetwork != null) {
            Map networks = this.getContainerInfo().getNetworkSettings().getNetworks();
            for (ContainerNetwork network : networks.values()) {
                if (!thisNetwork.getId().equals(network.getNetworkID())) continue;
                return network.getIpAddress();
            }
        }
        return "127.0.0.1";
    }

    public boolean isServiceReady(ExasolService service) {
        return this.status.isServiceReady(service);
    }

    public DatabaseService getDatabaseService(String databaseName) {
        return new DatabaseServiceFactory((Container<? extends Container<?>>)this, this.getClusterConfiguration()).getDatabaseService(databaseName);
    }

    public ExaOperation getExaOperation() {
        return this.exaOperation;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Container.ExecResult execInContainer(Charset charset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        if (this.dockerAccess.supportsDockerExec()) {
            return super.execInContainer(charset, command);
        }
        return this.dockerAccess.getSsh().execute(charset, command);
    }

    protected void containerIsStopping(InspectContainerResponse containerInfo) {
        InspectContainerResponse.ContainerState state = containerInfo.getState();
        ExitType exitType = this.errorWhileWaitingForServices || state.getOOMKilled() != false || state.getExitCodeLong() != 0L || state.getDead() != false ? ExitType.EXIT_ERROR : ExitType.EXIT_SUCCESS;
        this.collectSupportInformation(exitType);
        super.containerIsStopping(containerInfo);
    }

    public void stop() {
        if (this.isShouldBeReused() && TestcontainersConfiguration.getInstance().environmentSupportsReuse()) {
            LOGGER.info("Leaving container running since reuse is enabled. Don't forget to stop and remove the container manually using docker rm -f CONTAINER_ID.");
            this.collectSupportInformation(ExitType.EXIT_SUCCESS);
        } else {
            super.stop();
        }
    }

    private void collectSupportInformation(ExitType exitType) {
        if (this.dockerImageReference.hasMajor() && this.dockerImageReference.getMajor() >= 7) {
            this.supportInformationRetriever.run(exitType);
        } else {
            LOGGER.info("Skipping support information retrieval for version {}, only supported with version >= 7", (Object)this.dockerImageReference);
        }
    }

    public int getDefaultInternalBucketfsPort() {
        if (this.dockerImageReference.hasMajor() && this.dockerImageReference.hasMinor() && this.dockerImageReference.hasFix()) {
            if (this.dockerImageReference.getMajor() > 8 || this.dockerImageReference.getMajor() == 8 && this.dockerImageReference.getMinor() >= 29) {
                return 2581;
            }
            if (this.dockerImageReference.getMajor() >= 7) {
                return 2580;
            }
            return 6583;
        }
        throw new UnsupportedOperationException("Could not detect internal BucketFS port for custom image '" + String.valueOf(this.dockerImageReference) + "'. Please specify the port explicitly using withExposedPorts().");
    }

    public int getDefaultInternalRpcPort() {
        return 443;
    }

    public ExasolContainer<T> withJdbcConnectionTimeout(int timeoutInSeconds) {
        this.connectionWaitTimeout = Duration.ofSeconds(timeoutInSeconds);
        return this;
    }

    public int getJdbcConnectionTimeout() {
        return (int)this.connectionWaitTimeout.toSeconds();
    }

    public ExasolContainer<T> withJdbcLoginTimeout(Duration timeout) {
        this.jdbcLoginTimeout = timeout;
        return this;
    }

    @Deprecated(since="3.2.0")
    public T withConnectTimeoutSeconds(int connectTimeoutSeconds) {
        throw ExasolContainer.getTimeoutNotSupportedException();
    }

    @Deprecated(since="3.2.0")
    public T withStartupTimeout(Duration startupTimeout) {
        throw ExasolContainer.getTimeoutNotSupportedException();
    }

    public final synchronized ExasolDriverManager getDriverManager() {
        if (this.driverManager == null) {
            this.driverManager = new ExasolDriverManager(this.getDefaultBucket());
        }
        return this.driverManager;
    }

    public String getHostIp() {
        HostIpDetector detector = new HostIpDetector((Container<? extends Container<?>>)this);
        return detector.getHostIp();
    }

    public ExasolContainer<T> withSupportInformationRecordedAtExit(Path targetDirectory, ExitType exitType) {
        this.supportInformationRetriever.monitorExit(exitType);
        this.supportInformationRetriever.mapTargetDirectory(targetDirectory);
        return this;
    }

    public Optional<X509Certificate> getTlsCertificate() {
        return this.certificateProvider.getCertificate();
    }

    public Optional<String> getTlsCertificateFingerprint() {
        return this.certificateProvider.getSha256Fingerprint();
    }

    private void copyAuthorizedKeys(DockerAccess accessProvider) {
        this.withCopyToContainer(accessProvider.getSshKeys().getPublicKeyTransferable(), "/root/.ssh/authorized_keys");
    }

    DockerAccess createDockerAccess() {
        Path dir = this.getTemporaryCredentialsDirectory();
        ExasolContainer.ensureExists(dir);
        return DockerAccess.builder().temporaryCredentialsDirectory(dir).sshKeys(this.getSshKeys()).dockerProbe(this::probeFile).sessionBuilderProvider(this::getSessionBuilder).build();
    }

    private static void ensureExists(Path directory) {
        if (Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private SshKeys getSshKeys() {
        try {
            return SshKeys.builder().privateKey(this.getTemporaryCredentialsDirectory().resolve("id_rsa")).publicKey(this.getTemporaryCredentialsDirectory().resolve("id_rsa.pub")).build();
        }
        catch (JSchException | IOException exception) {
            throw new ExasolContainerInitializationException("Could not create SSH key pair", (Exception)exception);
        }
    }

    Path getTemporaryCredentialsDirectory() {
        return this.temporaryCredentialsDirectory;
    }

    SessionBuilder getSessionBuilder() {
        return new SessionBuilder().user("root").host(this.getHost()).port(this.getMappedPort(20002)).config("StrictHostKeyChecking", "no");
    }

    public Container.ExecResult probeFile(String path) {
        try {
            Container.ExecResult r = super.execInContainer(StandardCharsets.UTF_8, new String[]{"test", "-f", path});
            if (r.getExitCode() != 0) {
                LOGGER.debug("File not found: {}, exit code: {}", (Object)path, (Object)r.getExitCode());
            }
            return r;
        }
        catch (IOException | UnsupportedOperationException exception) {
            throw new SshException(ExaError.messageBuilder((String)"E-ETC-22").message("Failed to probe existence of file {{path}}", new Object[]{path}).toString(), exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new SshException("Probing file " + path + "was interrupted", interruptedException);
        }
    }
}

