/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.slc.fileprovider;

import com.exasol.containers.slc.fileprovider.FileProvider;
import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChecksumVerifyingFileProvider
implements FileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChecksumVerifyingFileProvider.class);
    private final FileProvider delegate;
    private final String expectedSha512sum;

    ChecksumVerifyingFileProvider(FileProvider delegate, String sha512sum) {
        this.delegate = delegate;
        this.expectedSha512sum = sha512sum;
    }

    @Override
    public Path getLocalFile() {
        Path localFile = this.delegate.getLocalFile();
        String calculatedChecksum = ChecksumVerifyingFileProvider.calculateSha512sum(localFile);
        if (calculatedChecksum.equalsIgnoreCase(this.expectedSha512sum)) {
            LOGGER.debug("Sha512 checksum of file '{}' is correct: {}", (Object)localFile, (Object)calculatedChecksum);
            return localFile;
        }
        throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETC-37").message("Sha512 checksum verification failed for file {{file}}, expected {{expected checksum}} but got {{calculated checksum}}", new Object[]{localFile, this.expectedSha512sum, calculatedChecksum}).toString());
    }

    private static String calculateSha512sum(Path localFile) {
        byte[] fileContent = ChecksumVerifyingFileProvider.readContent(localFile);
        byte[] checksum = ChecksumVerifyingFileProvider.calculateSha512Checksum(fileContent);
        return ChecksumVerifyingFileProvider.formatChecksum(checksum);
    }

    private static byte[] readContent(Path localFile) {
        try {
            return Files.readAllBytes(localFile);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Failed to read file content from '" + String.valueOf(localFile) + "'", exception);
        }
    }

    private static byte[] calculateSha512Checksum(byte[] content) {
        MessageDigest md = ChecksumVerifyingFileProvider.createDigest();
        md.update(content);
        return md.digest();
    }

    private static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new IllegalStateException("Failed to create SHA-512 message digest.", exception);
        }
    }

    private static String formatChecksum(byte[] digest) {
        BigInteger bigInt = new BigInteger(1, digest);
        return ChecksumVerifyingFileProvider.zeroPad(bigInt.toString(16));
    }

    private static String zeroPad(String checksum) {
        while (((String)checksum).length() < 64) {
            checksum = "0" + (String)checksum;
        }
        return checksum;
    }

    @Override
    public String getFileName() {
        return this.delegate.getFileName();
    }
}

