/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.slc.fileprovider;

import com.exasol.containers.slc.ScriptLanguageContainer;
import com.exasol.containers.slc.fileprovider.CachingUrlFileProvider;
import com.exasol.containers.slc.fileprovider.ChecksumVerifyingFileProvider;
import com.exasol.containers.slc.fileprovider.LocalFileProvider;
import com.exasol.errorreporting.ExaError;
import java.nio.file.Path;

public interface FileProvider {
    public static FileProvider forSlc(ScriptLanguageContainer slc) {
        FileProvider provider = FileProvider.createProvider(slc);
        if (slc.getSha512sum() != null) {
            return new ChecksumVerifyingFileProvider(provider, slc.getSha512sum());
        }
        return provider;
    }

    private static FileProvider createProvider(ScriptLanguageContainer slc) {
        if (slc.getLocalFile() != null && slc.getUrl() != null) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-41").message("SLC must have either a local file or a URL, not both", new Object[0]).toString());
        }
        if (slc.getLocalFile() != null) {
            return new LocalFileProvider(slc.getLocalFile());
        }
        if (slc.getUrl() != null) {
            return new CachingUrlFileProvider(slc.getUrl());
        }
        throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-ETC-39").message("SLC must have either a local file or a URL", new Object[0]).toString());
    }

    public Path getLocalFile();

    public String getFileName();
}

