/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.status;

import com.exasol.containers.ExasolService;
import com.exasol.containers.slc.ScriptLanguageContainer;
import com.exasol.containers.status.ServiceStatus;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ContainerStatus
implements Serializable {
    private static final long serialVersionUID = 8005816552446840053L;
    private final String containerId;
    private final Map<ExasolService, ServiceStatus> serviceStatuses = new EnumMap<ExasolService, ServiceStatus>(ExasolService.class);
    private final Set<String> appliedWorkarounds = new HashSet<String>();
    private final Set<ScriptLanguageContainer> installedSlcs = new HashSet<ScriptLanguageContainer>();

    private ContainerStatus(String containerId) {
        this.containerId = containerId;
        for (ExasolService service : ExasolService.values()) {
            this.serviceStatuses.put(service, ServiceStatus.NOT_CHECKED);
        }
    }

    public static ContainerStatus create(String containerId) {
        return new ContainerStatus(containerId);
    }

    public String getContainerId() {
        return this.containerId;
    }

    public ServiceStatus getServiceStatus(ExasolService service) {
        return this.serviceStatuses.get((Object)service);
    }

    public boolean isServiceReady(ExasolService service) {
        return this.serviceStatuses.get((Object)service) == ServiceStatus.READY;
    }

    public void setServiceStatus(ExasolService service, ServiceStatus serviceStatus) {
        this.serviceStatuses.put(service, serviceStatus);
    }

    public Set<String> getAppliedWorkarounds() {
        return this.appliedWorkarounds;
    }

    public void addAllAppliedWorkarounds(Set<String> ids) {
        this.appliedWorkarounds.addAll(ids);
    }

    public boolean isInstalled(ScriptLanguageContainer slc) {
        return this.installedSlcs.contains(slc);
    }

    public void addInstalledSlc(ScriptLanguageContainer slc) {
        this.installedSlcs.add(slc);
    }

    public String toString() {
        return "ContainerStatus [containerId=" + this.containerId + ", serviceStatuses=" + String.valueOf(this.serviceStatuses) + ", appliedWorkarounds=" + String.valueOf(this.appliedWorkarounds) + ", installedSlcs=" + String.valueOf(this.installedSlcs) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.containerId, this.serviceStatuses, this.appliedWorkarounds, this.installedSlcs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContainerStatus)) {
            return false;
        }
        ContainerStatus other = (ContainerStatus)obj;
        return Objects.equals(this.containerId, other.containerId) && Objects.equals(this.serviceStatuses, other.serviceStatuses) && Objects.equals(this.appliedWorkarounds, other.appliedWorkarounds) && Objects.equals(this.installedSlcs, other.installedSlcs);
    }
}

