/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.parquetio.data;

import com.exasol.parquetio.data.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class GenericRow
implements Row {
    private final MessageType schema;
    private final List<Object> values;

    public GenericRow(List<Object> values) {
        this.schema = null;
        this.values = Collections.unmodifiableList(values);
    }

    public GenericRow(MessageType schema, List<Object> values) {
        this.schema = schema;
        this.values = Collections.unmodifiableList(values);
    }

    public static GenericRow of(Object ... values) {
        return new GenericRow(Arrays.asList(values));
    }

    public static GenericRow of(MessageType schema, Object ... values) {
        return new GenericRow(schema, Arrays.asList(values));
    }

    @Override
    public boolean hasFieldName(String fieldName) {
        return this.schema.containsField(fieldName);
    }

    @Override
    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.size());
        for (Type type : this.schema.getFields()) {
            fieldNames.add(type.getName());
        }
        return fieldNames;
    }

    @Override
    public Object getValue(int position) {
        return this.values.get(position);
    }

    @Override
    public Object getValue(String fieldName) {
        if (this.schema == null) {
            throw new IllegalArgumentException("Generic row does not have a schema. Please use positional access method.");
        }
        int fieldPosition = this.schema.getFieldIndex(fieldName);
        return this.values.get(fieldPosition);
    }

    @Override
    public List<Object> getValues() {
        return this.values;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericRow)) {
            return false;
        }
        GenericRow otherRow = (GenericRow)other;
        return this.values.equals(otherRow.values);
    }

    public int hashCode() {
        return Objects.hashCode(this.getValues());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Row(values=[");
        for (int index = 0; index < this.size(); ++index) {
            if (index > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.getValue(index));
        }
        stringBuilder.append("])");
        return stringBuilder.toString();
    }
}

