/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.util;

import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;

public final class Filters$ {
    public static final Filters$ MODULE$;

    static {
        new Filters$();
    }

    public String createWhereClause(StructType schema2, Seq<Filter> filters) {
        Map dataTypes = ((TraversableOnce)schema2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(StructField field) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)field.dataType());
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return ((TraversableOnce)filters.flatMap((Function1)new Serializable(dataTypes){
            public static final long serialVersionUID = 0L;
            private final Map dataTypes$1;

            public final Iterable<String> apply(Filter x$1) {
                return Option$.MODULE$.option2Iterable(Filters$.MODULE$.filterExpr(x$1, (Map<String, DataType>)this.dataTypes$1));
            }
            {
                this.dataTypes$1 = dataTypes$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<String> filterExpr(Filter filter, Map<String, DataType> dataTypes) {
        Filter filter2;
        boolean bl = false;
        Not not = null;
        Filter filter3 = filter;
        if (filter3 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter3;
            String a = equalTo.attribute();
            Object v = equalTo.value();
            return this.comparisonExpr(a, v, "=", dataTypes);
        }
        if (filter3 instanceof Not) {
            bl = true;
            not = (Not)filter3;
            Filter filter4 = not.child();
            if (filter4 instanceof EqualTo) {
                EqualTo equalTo = (EqualTo)filter4;
                String a = equalTo.attribute();
                Object v = equalTo.value();
                return this.comparisonExpr(a, v, "!=", dataTypes);
            }
        }
        if (filter3 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter3;
            String a = greaterThan.attribute();
            Object v = greaterThan.value();
            return this.comparisonExpr(a, v, ">", dataTypes);
        }
        if (filter3 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter3;
            String a = greaterThanOrEqual.attribute();
            Object v = greaterThanOrEqual.value();
            return this.comparisonExpr(a, v, ">=", dataTypes);
        }
        if (filter3 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter3;
            String a = lessThan.attribute();
            Object v = lessThan.value();
            return this.comparisonExpr(a, v, "<", dataTypes);
        }
        if (filter3 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter3;
            String a = lessThanOrEqual.attribute();
            Object v = lessThanOrEqual.value();
            return this.comparisonExpr(a, v, "<=", dataTypes);
        }
        if (filter3 instanceof IsNull) {
            IsNull isNull = (IsNull)filter3;
            String a = isNull.attribute();
            return Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " IS NULL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a})));
        }
        if (filter3 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter3;
            String a = isNotNull.attribute();
            return Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " IS NOT NULL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a})));
        }
        if (filter3 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter3;
            String a = stringEndsWith.attribute();
            String v = stringEndsWith.value();
            return Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " LIKE '%", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a, v})));
        }
        if (filter3 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter3;
            String a = stringContains.attribute();
            String v = stringContains.value();
            return Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " LIKE '%", "%')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a, v})));
        }
        if (filter3 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter3;
            String a = stringStartsWith.attribute();
            String v = stringStartsWith.value();
            return Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " LIKE '", "%')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a, v})));
        }
        if (filter3 instanceof In) {
            In in = (In)filter3;
            String a = in.attribute();
            Object[] vs = in.values();
            return this.inExpr(a, vs, "IN", dataTypes);
        }
        if (bl && (filter2 = not.child()) instanceof In) {
            In in = (In)filter2;
            String a = in.attribute();
            Object[] vs = in.values();
            return this.inExpr(a, vs, "NOT IN", dataTypes);
        }
        if (bl) {
            Filter f = not.child();
            return this.notExpr(f, dataTypes);
        }
        if (filter3 instanceof And) {
            And and = (And)filter3;
            Filter lf = and.left();
            Filter rf = and.right();
            return this.binaryExpr(lf, rf, "AND", dataTypes);
        }
        if (!(filter3 instanceof Or)) return None$.MODULE$;
        Or or = (Or)filter3;
        Filter lf = or.left();
        Filter rf = or.right();
        return this.binaryExpr(lf, rf, "OR", dataTypes);
    }

    public String isQuotedValue(DataType dataType, Object value) {
        DataType dataType2 = dataType;
        String string = StringType$.MODULE$.equals(dataType2) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})) : (DateType$.MODULE$.equals(dataType2) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})) : (TimestampType$.MODULE$.equals(dataType2) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}))));
        return string;
    }

    public Option<String> comparisonExpr(String name, Object value, String op, Map<String, DataType> types) {
        return types.get((Object)name).flatMap((Function1)new Serializable(name, value, op){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final Object value$1;
            private final String op$1;

            public final Option<String> apply(DataType x0$1) {
                DataType dataType = x0$1;
                String newValue = Filters$.MODULE$.isQuotedValue(dataType, this.value$1);
                Option option = Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, this.op$1, newValue})));
                return option;
            }
            {
                this.name$1 = name$1;
                this.value$1 = value$1;
                this.op$1 = op$1;
            }
        });
    }

    public Option<String> inExpr(String name, Object[] values, String op, Map<String, DataType> types) {
        return types.get((Object)name).flatMap((Function1)new Serializable(name, values, op){
            public static final long serialVersionUID = 0L;
            private final String name$2;
            private final Object[] values$1;
            private final String op$2;

            public final Option<String> apply(DataType x0$2) {
                DataType dataType = x0$2;
                String[] newValues = (String[])Predef$.MODULE$.genericArrayOps((Object)this.values$1).map((Function1)new Serializable(this, dataType){
                    public static final long serialVersionUID = 0L;
                    private final DataType x1$1;

                    public final String apply(Object v) {
                        return Filters$.MODULE$.isQuotedValue(this.x1$1, v);
                    }
                    {
                        this.x1$1 = x1$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                Option option = Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " ", " (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2, this.op$2, Predef$.MODULE$.refArrayOps((Object[])newValues).mkString(",")})));
                return option;
            }
            {
                this.name$2 = name$2;
                this.values$1 = values$1;
                this.op$2 = op$2;
            }
        });
    }

    public Option<String> notExpr(Filter f, Map<String, DataType> types) {
        return this.filterExpr(f, types).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String expr) {
                return Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(NOT (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr})));
            }
        });
    }

    public Option<String> binaryExpr(Filter lf, Filter rf, String op, Map<String, DataType> types) {
        Option<String> leftOpt = this.filterExpr(lf, types);
        if (leftOpt.isDefined()) {
            Option<String> rightOpt = this.filterExpr(rf, types);
            return rightOpt.isDefined() ? Option$.MODULE$.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", ") ", " (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftOpt.get(), op, rightOpt.get()}))) : None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private Filters$() {
        MODULE$ = this;
    }
}

