/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.rdd;

import com.exasol.errorreporting.ExaError;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.spark.rdd.ExasolRDDPartition;
import com.exasol.spark.util.ExasolConnectionManager;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\u000b\u0016\u0001yA\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005o!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!1\u0006A!A!\u0002\u00139\u0006\"B/\u0001\t\u0003q\u0006bB3\u0001\u0001\u0004%IA\u001a\u0005\b[\u0002\u0001\r\u0011\"\u0003o\u0011\u0019!\b\u0001)Q\u0005O\"9a\u000f\u0001a\u0001\n\u00139\b\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u000f\u0005\u0015\u0001\u0001)Q\u0005q\"I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111\u0002\u0005\n\u0003'\u0001\u0001\u0019!C\u0005\u0003+A\u0001\"!\u0007\u0001A\u0003&\u0011Q\u0002\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\n\u0001\t\u0003\n9\u0003C\u0004\u00026\u0001!\t%a\u000e\u0003\u0013\u0015C\u0018m]8m%\u0012#%B\u0001\f\u0018\u0003\r\u0011H\r\u001a\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0015D\u0018m]8m\u0015\u0005a\u0012aA2p[\u000e\u00011c\u0001\u0001 _A\u0019\u0001eJ\u0015\u000e\u0003\u0005R!A\u0006\u0012\u000b\u0005a\u0019#B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001eL!\u0001K\u0011\u0003\u0007I#E\t\u0005\u0002+[5\t1F\u0003\u0002-E\u0005\u00191/\u001d7\n\u00059Z#a\u0001*poB\u0011\u0001gM\u0007\u0002c)\u0011!GI\u0001\tS:$XM\u001d8bY&\u0011A'\r\u0002\b\u0019><w-\u001b8h\u0003\t\u00198-F\u00018!\tA\u0014(D\u0001#\u0013\tQ$E\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0002tG\u0002B#AA\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\u0013Q\u0014\u0018M\\:jK:$\u0018aC9vKJL8\u000b\u001e:j]\u001e\u0004\"!\u0012'\u000f\u0005\u0019S\u0005CA$@\u001b\u0005A%BA%\u001e\u0003\u0019a$o\\8u}%\u00111jP\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L\u007f\u0005Y\u0011/^3ssN\u001b\u0007.Z7b!\t\tF+D\u0001S\u0015\t\u00196&A\u0003usB,7/\u0003\u0002V%\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000f5\fg.Y4feB\u0011\u0001lW\u0007\u00023*\u0011!lF\u0001\u0005kRLG.\u0003\u0002]3\n9R\t_1t_2\u001cuN\u001c8fGRLwN\\'b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b}\u000b'm\u00193\u0011\u0005\u0001\u0004Q\"A\u000b\t\u000bU2\u0001\u0019A\u001c\t\u000b\r3\u0001\u0019\u0001#\t\u000b=3\u0001\u0019\u0001)\t\u000bY3\u0001\u0019A,\u0002\u001d5\f\u0017N\\\"p]:,7\r^5p]V\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002k3\u0005!!\u000e\u001a2d\u0013\ta\u0017NA\u0007F1\u0006\u001buN\u001c8fGRLwN\\\u0001\u0013[\u0006LgnQ8o]\u0016\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0002peB\u0011a\b]\u0005\u0003c~\u0012A!\u00168ji\"91\u000fCA\u0001\u0002\u00049\u0017a\u0001=%c\u0005yQ.Y5o\u0007>tg.Z2uS>t\u0007\u0005\u000b\u0002\n{\u0005iQ.Y5o'R\fG/Z7f]R,\u0012\u0001\u001f\t\u0003svl\u0011A\u001f\u0006\u0003YmT\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fu\nI1\u000b^1uK6,g\u000e^\u0001\u0012[\u0006Lgn\u0015;bi\u0016lWM\u001c;`I\u0015\fHcA8\u0002\u0004!91oCA\u0001\u0002\u0004A\u0018AD7bS:\u001cF/\u0019;f[\u0016tG\u000f\t\u0015\u0003\u0019u\nQ\"\\1j]J+7/\u001e7u'\u0016$XCAA\u0007!\rA\u0017qB\u0005\u0004\u0003#I'\u0001D#Y\u0003J+7/\u001e7u'\u0016$\u0018!E7bS:\u0014Vm];miN+Go\u0018\u0013fcR\u0019q.a\u0006\t\u0011Mt\u0011\u0011!a\u0001\u0003\u001b\ta\"\\1j]J+7/\u001e7u'\u0016$\b\u0005\u000b\u0002\u0010{\u0005\u00112\r\\8tK6\u000b\u0017N\u001c*fg>,(oY3t)\u0005y\u0017\u0001F2sK\u0006$X-T1j]\u000e{gN\\3di&|g\u000eF\u0001h\u000359W\r\u001e)beRLG/[8ogV\u0011\u0011\u0011\u0006\t\u0006}\u0005-\u0012qF\u0005\u0004\u0003[y$!B!se\u0006L\bc\u0001\u001d\u00022%\u0019\u00111\u0007\u0012\u0003\u0013A\u000b'\u000f^5uS>t\u0017aB2p[B,H/\u001a\u000b\u0007\u0003s\tY%a\u0014\u0011\u000b\u0005m\u0012QI\u0015\u000f\t\u0005u\u0012\u0011\t\b\u0004\u000f\u0006}\u0012\"\u0001!\n\u0007\u0005\rs(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0013\u0011\n\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111I \t\u000f\u000553\u00031\u0001\u00020\u0005)1\u000f\u001d7ji\"9\u0011\u0011K\nA\u0002\u0005M\u0013aB2p]R,\u0007\u0010\u001e\t\u0004q\u0005U\u0013bAA,E\tYA+Y:l\u0007>tG/\u001a=u\u0001")
public class ExasolRDD
extends RDD<Row> {
    private final transient SparkContext sc;
    private final String queryString;
    private final StructType querySchema;
    private final ExasolConnectionManager manager;
    private transient EXAConnection mainConnection;
    private transient Statement mainStatement;
    private transient EXAResultSet mainResultSet;
    private volatile transient byte bitmap$inittrans$0;

    public SparkContext sc() {
        return this.sc;
    }

    private EXAConnection mainConnection() {
        if ((byte)(this.bitmap$inittrans$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/rdd/ExasolRDD.scala: 38");
        }
        return this.mainConnection;
    }

    private void mainConnection_$eq(EXAConnection x$1) {
        this.mainConnection = x$1;
        this.bitmap$inittrans$0 = (byte)(this.bitmap$inittrans$0 | 1);
    }

    private Statement mainStatement() {
        if ((byte)(this.bitmap$inittrans$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/rdd/ExasolRDD.scala: 39");
        }
        return this.mainStatement;
    }

    private void mainStatement_$eq(Statement x$1) {
        this.mainStatement = x$1;
        this.bitmap$inittrans$0 = (byte)(this.bitmap$inittrans$0 | 2);
    }

    private EXAResultSet mainResultSet() {
        if ((byte)(this.bitmap$inittrans$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/rdd/ExasolRDD.scala: 40");
        }
        return this.mainResultSet;
    }

    private void mainResultSet_$eq(EXAResultSet x$1) {
        this.mainResultSet = x$1;
        this.bitmap$inittrans$0 = (byte)(this.bitmap$inittrans$0 | 4);
    }

    public void closeMainResources() {
        if (this.mainConnection() != null) {
            this.mainConnection().close();
        }
        if (this.mainStatement() != null) {
            this.mainStatement().close();
        }
        if (this.mainResultSet() != null) {
            this.mainResultSet().close();
            return;
        }
    }

    public EXAConnection createMainConnection() {
        EXAConnection conn = this.manager.mainConnection();
        if (conn == null) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "Main EXAConnection is null!");
            throw new RuntimeException(ExaError.messageBuilder((String)"F-SEC-11").message("Could not establish main JDBC connection for query.", new Object[0]).mitigation("Please make sure that there is a network connection between Spark and Exasol clusters.", new Object[0]).toString());
        }
        int cnt = this.manager.initParallel(conn);
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Initiated ").append(cnt).append(" parallel exasol (sub) connections").toString());
        this.sc().addSparkListener((SparkListenerInterface)new SparkListener(this){
            private final /* synthetic */ ExasolRDD $outer;

            public void onApplicationEnd(SparkListenerApplicationEnd appEnd) {
                this.$outer.closeMainResources();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return conn;
    }

    public Partition[] getPartitions() {
        this.mainConnection_$eq(this.createMainConnection());
        this.mainStatement_$eq(this.mainConnection().createStatement());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Executing enriched query '").append($this.queryString).append("'.").toString());
        this.mainResultSet_$eq((EXAResultSet)this.mainStatement().executeQuery(this.queryString));
        int handle = this.mainResultSet().GetHandle();
        Seq partitions = (Seq)((TraversableLike)this.manager.subConnections(this.mainConnection()).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String url = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                return new ExasolRDDPartition(idx, handle, url);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("The number of partitions is ").append(partitions.size()).toString());
        return (Partition[])partitions.toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Iterator<Row> compute(Partition split, TaskContext context) {
        BooleanRef closed = BooleanRef.create((boolean)false);
        ObjectRef resultSet = ObjectRef.create(null);
        Statement stmt = null;
        ObjectRef conn = ObjectRef.create(null);
        TaskContext _ = context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.close$1(closed, resultSet, stmt, conn);
            return BoxedUnit.UNIT;
        });
        ExasolRDDPartition partition = (ExasolRDDPartition)split;
        int subHandle = partition.handle();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sub connection with url = ").append(partition.connectionUrl()).append(" and handle = ").append(subHandle).toString());
        if (subHandle == -1) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "Sub connection handle is -1, no results, return empty iterator");
            return package$.MODULE$.Iterator().empty();
        }
        conn.elem = this.manager.subConnection(partition.connectionUrl());
        resultSet.elem = ((EXAConnection)conn.elem).DescribeResult(subHandle);
        return JdbcUtils$.MODULE$.resultSetToRows((ResultSet)resultSet.elem, this.querySchema);
    }

    private final void close$1(BooleanRef closed$1, ObjectRef resultSet$1, Statement stmt$1, ObjectRef conn$1) {
        block13: {
            if (closed$1.elem) {
                return;
            }
            try {
                if ((ResultSet)resultSet$1.elem != null) {
                    ((ResultSet)resultSet$1.elem).close();
                }
            }
            catch (Exception e) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Received an exception closing sub resultSet", e);
            }
            try {
                if (stmt$1 != null && !stmt$1.isClosed()) {
                    stmt$1.close();
                }
            }
            catch (Exception e) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Received an exception closing sub statement", e);
            }
            try {
                if ((EXAConnection)conn$1.elem == null) break block13;
                if (!((EXAConnection)conn$1.elem).isClosed() && !((EXAConnection)conn$1.elem).getAutoCommit()) {
                    try {
                        ((EXAConnection)conn$1.elem).commit();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Received exception committing sub connection", e);
                        }
                        throw throwable;
                    }
                }
                ((EXAConnection)conn$1.elem).close();
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> "Closed a sub connection");
            }
            catch (Exception e) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Received an exception closing sub connection", e);
            }
        }
        closed$1.elem = true;
    }

    public ExasolRDD(SparkContext sc, String queryString, StructType querySchema, ExasolConnectionManager manager) {
        this.sc = sc;
        this.queryString = queryString;
        this.querySchema = querySchema;
        this.manager = manager;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Row.class));
        this.mainConnection = null;
        this.bitmap$inittrans$0 = (byte)(this.bitmap$inittrans$0 | 1);
        this.mainStatement = null;
        this.bitmap$inittrans$0 = (byte)(this.bitmap$inittrans$0 | 2);
        this.mainResultSet = null;
        this.bitmap$inittrans$0 = (byte)(this.bitmap$inittrans$0 | 4);
    }
}

