/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.util;

import com.exasol.sql.expression.BooleanExpression;
import com.exasol.sql.expression.BooleanTerm;
import com.exasol.sql.expression.ExpressionTerm;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.literal.BigDecimalLiteral;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Filters$ {
    public static Filters$ MODULE$;

    static {
        new Filters$();
    }

    public Seq<BooleanExpression> booleanExpressionFromFilters(Seq<Filter> filters) {
        return (Seq)((GenericTraversableTemplate)((TraversableLike)filters.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.filterToBooleanExpression((Filter)x$1), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toList(), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<BooleanExpression> filterToBooleanExpression(Filter filter) {
        Filter filter2;
        BooleanExpression booleanExpression;
        boolean bl = false;
        Not not = null;
        Filter filter3 = filter;
        if (filter3 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter3;
            String attribute = equalTo.attribute();
            Object value = equalTo.value();
            booleanExpression = BooleanTerm.eq((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression)this.getLiteral(value));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof Not) {
            bl = true;
            not = (Not)filter3;
            Filter filter4 = not.child();
            if (filter4 instanceof EqualTo) {
                EqualTo equalTo = (EqualTo)filter4;
                String attribute = equalTo.attribute();
                Object value = equalTo.value();
                booleanExpression = BooleanTerm.compare((ValueExpression)ExpressionTerm.column((String)attribute), (String)"<>", (ValueExpression)this.getLiteral(value));
                return Option$.MODULE$.apply((Object)booleanExpression);
            }
        }
        if (filter3 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter3;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            booleanExpression = BooleanTerm.gt((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression)this.getLiteral(value));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter3;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            booleanExpression = BooleanTerm.ge((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression)this.getLiteral(value));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter3;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            booleanExpression = BooleanTerm.lt((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression)this.getLiteral(value));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter3;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            booleanExpression = BooleanTerm.le((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression)this.getLiteral(value));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof IsNull) {
            IsNull isNull = (IsNull)filter3;
            String attribute = isNull.attribute();
            booleanExpression = BooleanTerm.isNull((ValueExpression)ExpressionTerm.column((String)attribute));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter3;
            String attribute = isNotNull.attribute();
            booleanExpression = BooleanTerm.isNotNull((ValueExpression)ExpressionTerm.column((String)attribute));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter3;
            String attribute = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            booleanExpression = BooleanTerm.like((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression)ExpressionTerm.stringLiteral((String)new StringBuilder(1).append("%").append(value).toString()));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter3;
            String attribute = stringContains.attribute();
            String value = stringContains.value();
            booleanExpression = BooleanTerm.like((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression)ExpressionTerm.stringLiteral((String)new StringBuilder(2).append("%").append(value).append("%").toString()));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter3;
            String attribute = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            booleanExpression = BooleanTerm.like((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression)ExpressionTerm.stringLiteral((String)new StringBuilder(1).append(value).append("%").toString()));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof In) {
            In in = (In)filter3;
            String attribute = in.attribute();
            Object[] values = in.values();
            booleanExpression = BooleanTerm.in((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression[])((ValueExpression[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.getLiteral(x$3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ValueExpression.class)))));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (bl && (filter2 = not.child()) instanceof In) {
            In in = (In)filter2;
            String attribute = in.attribute();
            Object[] values = in.values();
            booleanExpression = BooleanTerm.notIn((ValueExpression)ExpressionTerm.column((String)attribute), (ValueExpression[])((ValueExpression[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.getLiteral(x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ValueExpression.class)))));
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (bl) {
            Filter notFilter = not.child();
            booleanExpression = (BooleanExpression)this.filterToBooleanExpression(notFilter).map((Function1 & Serializable & scala.Serializable)x$5 -> BooleanTerm.not((BooleanExpression)x$5)).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof And) {
            And and = (And)filter3;
            Filter leftFilter = and.left();
            Filter rightFilter = and.right();
            booleanExpression = this.andFilterToExpression(leftFilter, rightFilter);
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        if (filter3 instanceof Or) {
            Or or = (Or)filter3;
            Filter leftFilter = or.left();
            Filter rightFilter = or.right();
            booleanExpression = this.orFilterToExpression(leftFilter, rightFilter);
            return Option$.MODULE$.apply((Object)booleanExpression);
        }
        booleanExpression = null;
        return Option$.MODULE$.apply((Object)booleanExpression);
    }

    private BooleanExpression andFilterToExpression(Filter leftFilter, Filter rightFilter) {
        Option<BooleanExpression> leftExpr = this.filterToBooleanExpression(leftFilter);
        Option<BooleanExpression> rightExpr = this.filterToBooleanExpression(rightFilter);
        if (leftExpr.isDefined() && rightExpr.isDefined()) {
            return BooleanTerm.and((BooleanExpression[])new BooleanExpression[]{(BooleanExpression)leftExpr.getOrElse((Function0 & Serializable & scala.Serializable)() -> null), (BooleanExpression)rightExpr.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)});
        }
        return null;
    }

    private BooleanExpression orFilterToExpression(Filter leftFilter, Filter rightFilter) {
        Option<BooleanExpression> leftExpr = this.filterToBooleanExpression(leftFilter);
        Option<BooleanExpression> rightExpr = this.filterToBooleanExpression(rightFilter);
        if (leftExpr.isDefined() && rightExpr.isDefined()) {
            return BooleanTerm.or((BooleanExpression[])new BooleanExpression[]{(BooleanExpression)leftExpr.getOrElse((Function0 & Serializable & scala.Serializable)() -> null), (BooleanExpression)rightExpr.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)});
        }
        return null;
    }

    private ValueExpression getLiteral(Object value) {
        Object object = value;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return ExpressionTerm.booleanLiteral((boolean)bl);
        }
        if (object instanceof String) {
            String string = (String)object;
            return ExpressionTerm.stringLiteral((String)string);
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return ExpressionTerm.integerLiteral((int)by);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return ExpressionTerm.integerLiteral((int)s);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return ExpressionTerm.integerLiteral((int)n);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return ExpressionTerm.longLiteral((long)l);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return ExpressionTerm.floatLiteral((float)f);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return ExpressionTerm.doubleLiteral((double)d);
        }
        if (object instanceof scala.math.BigDecimal) {
            scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
            return BigDecimalLiteral.of((BigDecimal)bigDecimal.underlying());
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return BigDecimalLiteral.of((BigDecimal)bigDecimal);
        }
        return ExpressionTerm.stringLiteral((String)String.valueOf(value));
    }

    private Filters$() {
        MODULE$ = this;
    }
}

