/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.util;

import com.exasol.errorreporting.ExaError;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Types$
implements Logging {
    public static Types$ MODULE$;
    private final int MAX_PRECISION_EXASOL;
    private final int MAX_SCALE_EXASOL;
    private final DecimalType LongDecimal;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$init$0;
    private volatile transient boolean bitmap$inittrans$0;

    static {
        new Types$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        if (!this.bitmap$inittrans$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/util/Types.scala: 14");
        }
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
        this.bitmap$inittrans$0 = true;
    }

    private int MAX_PRECISION_EXASOL() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/util/Types.scala: 16");
        }
        return this.MAX_PRECISION_EXASOL;
    }

    private int MAX_SCALE_EXASOL() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/util/Types.scala: 17");
        }
        return this.MAX_SCALE_EXASOL;
    }

    public DecimalType LongDecimal() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/util/Types.scala: 19");
        }
        return this.LongDecimal;
    }

    public StructType createSparkStructType(ResultSetMetaData rsmd) {
        int columnCnt = rsmd.getColumnCount();
        StructField[] fields = new StructField[columnCnt];
        for (int idx = 0; idx < columnCnt; ++idx) {
            String columnName = rsmd.getColumnLabel(idx + 1);
            int columnDataType = rsmd.getColumnType(idx + 1);
            int columnPrecision = rsmd.getPrecision(idx + 1);
            int columnScale = rsmd.getScale(idx + 1);
            boolean isSigned = rsmd.isSigned(idx + 1);
            boolean isNullable = rsmd.isNullable(idx + 1) != 0;
            DataType columnType = this.createSparkTypeFromSQLType(columnDataType, columnPrecision, columnScale, isSigned);
            fields[idx] = new StructField(columnName, columnType, isNullable, StructField$.MODULE$.apply$default$4());
        }
        return new StructType(fields);
    }

    public DataType createSparkTypeFromSQLType(int sqlType, int precision, int scale, boolean isSigned) {
        int n = sqlType;
        switch (n) {
            case -6: {
                return ShortType$.MODULE$;
            }
            case 5: {
                return ShortType$.MODULE$;
            }
            case 4: {
                if (isSigned) {
                    return IntegerType$.MODULE$;
                }
                return LongType$.MODULE$;
            }
            case -5: {
                if (isSigned) {
                    return LongType$.MODULE$;
                }
                return this.LongDecimal();
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    return this.boundedDecimal(precision, scale);
                }
                return DecimalType$.MODULE$.SYSTEM_DEFAULT();
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    return this.boundedDecimal(precision, scale);
                }
                return DecimalType$.MODULE$.SYSTEM_DEFAULT();
            }
            case 8: {
                return DoubleType$.MODULE$;
            }
            case 6: {
                return DoubleType$.MODULE$;
            }
            case 7: {
                return FloatType$.MODULE$;
            }
            case 1: {
                return StringType$.MODULE$;
            }
            case -15: {
                return StringType$.MODULE$;
            }
            case 12: {
                return StringType$.MODULE$;
            }
            case -9: {
                return StringType$.MODULE$;
            }
            case -1: {
                return StringType$.MODULE$;
            }
            case -16: {
                return StringType$.MODULE$;
            }
            case -2: {
                return BinaryType$.MODULE$;
            }
            case -3: {
                return BinaryType$.MODULE$;
            }
            case -4: {
                return BinaryType$.MODULE$;
            }
            case -7: {
                return BooleanType$.MODULE$;
            }
            case 16: {
                return BooleanType$.MODULE$;
            }
            case 91: {
                return DateType$.MODULE$;
            }
            case 92: {
                return TimestampType$.MODULE$;
            }
            case 93: {
                return TimestampType$.MODULE$;
            }
            case -8: {
                return LongType$.MODULE$;
            }
            case 2002: {
                return StringType$.MODULE$;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private DecimalType boundedDecimal(int precision, int scale) {
        return new DecimalType(package$.MODULE$.min(package$.MODULE$.min(precision, DecimalType$.MODULE$.MAX_PRECISION()), this.MAX_PRECISION_EXASOL()), package$.MODULE$.min(package$.MODULE$.min(scale, DecimalType$.MODULE$.MAX_SCALE()), this.MAX_SCALE_EXASOL()));
    }

    public int jdbcTypeFromSparkDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return 4;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return -5;
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return 8;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return 6;
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return 5;
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return -6;
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return -7;
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return 12;
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return 2004;
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return 93;
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return 91;
        }
        if (dataType2 instanceof DecimalType) {
            return 3;
        }
        throw new IllegalArgumentException(this.getUnsupportedDataTypeErrorCode(dataType));
    }

    public String exasolTypeFromSparkDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (ShortType$.MODULE$.equals(dataType2)) {
            return "SMALLINT";
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return "TINYINT";
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return "INTEGER";
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return "BIGINT";
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return "DOUBLE";
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return "FLOAT";
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return this.convertSparkPrecisionScaleToExasol(decimalType);
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return "BOOLEAN";
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return "CLOB";
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return "CLOB";
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return "DATE";
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return "TIMESTAMP";
        }
        throw new IllegalArgumentException(this.getUnsupportedDataTypeErrorCode(dataType));
    }

    private String getUnsupportedDataTypeErrorCode(DataType dataType) {
        return ExaError.messageBuilder((String)"F-SEC-8").message("Spark data type {{DATA_TYPE}} is not supported.", new Object[]{String.valueOf(dataType)}).ticketMitigation().toString();
    }

    public String convertSparkPrecisionScaleToExasol(DecimalType decimalType) {
        DecimalType boundedType = this.boundedDecimal(decimalType.precision(), decimalType.scale());
        return new StringBuilder(10).append("DECIMAL(").append(Integer.toString(boundedType.precision())).append(",").append(Integer.toString(boundedType.scale())).append(")").toString();
    }

    public StructType selectColumns(String[] columns, StructType schema) {
        Set fieldsNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).toSet();
        StructField[] newFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)fieldsNames.contains((Object)x$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> schema.apply(x$2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        StructType newSchema = new StructType(newFields);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Using a new pruned schema ").append(newSchema).toString());
        return newSchema;
    }

    public String createTableSchema(StructType schema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String fieldType = MODULE$.exasolTypeFromSparkDataType(field.dataType());
            String nameType = new StringBuilder(1).append(field.name()).append(" ").append(fieldType).toString();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = field.nullable();
            if (bl3) {
                return nameType;
            }
            if (!bl3) {
                bl = true;
                bl2 = bl3;
                DataType dataType = field.dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (dataType == null ? stringType$ != null : !dataType.equals(stringType$)) {
                    return new StringBuilder(9).append(nameType).append(" NOT NULL").toString();
                }
            }
            if (bl) {
                return nameType;
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl3));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
    }

    public int getMaxPrecisionExasol() {
        return this.MAX_PRECISION_EXASOL();
    }

    public int getMaxScaleExasol() {
        return this.MAX_SCALE_EXASOL();
    }

    private Types$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.MAX_PRECISION_EXASOL = 36;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.MAX_SCALE_EXASOL = 36;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.LongDecimal = new DecimalType(20, 0);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

