/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark;

import com.exasol.errorreporting.ExaError;
import com.exasol.spark.ExasolRelation;
import com.exasol.spark.util.ExasolConfiguration;
import com.exasol.spark.util.ExasolConfiguration$;
import com.exasol.spark.util.ExasolConnectionManager;
import com.exasol.spark.util.Types$;
import com.exasol.spark.writer.ExasolWriter;
import com.exasol.sql.StatementFactory;
import com.exasol.sql.dql.select.FromClause;
import com.exasol.sql.dql.select.SelectVisitor;
import com.exasol.sql.dql.select.rendering.SelectRenderer;
import com.exasol.sql.rendering.StringRendererConfig;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0007\u000f\u0001UAQA\r\u0001\u0005\u0002MBQA\u000e\u0001\u0005B]BQa\u0011\u0001\u0005B\u0011CQa\u0011\u0001\u0005BMCQa\u0011\u0001\u0005ByCaa\u001e\u0001!\n\u0013A\bBB>\u0001A\u0013%A\u0010\u0003\u0005\u0002\u001a\u0001\u0001K\u0011BA\u000e\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KA\u0001\"a\r\u0001A\u0013%\u0011Q\u0007\u0005\t\u0003{\u0001\u0001\u0015\"\u0003\u0002@!A\u0011Q\t\u0001\u0005\u00029\t9EA\u0007EK\u001a\fW\u000f\u001c;T_V\u00148-\u001a\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0015D\u0018m]8m\u0015\u0005\u0019\u0012aA2p[\u000e\u00011C\u0002\u0001\u00179%bs\u0006\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u001dj\u0011A\b\u0006\u0003?\u0001\nqa]8ve\u000e,7O\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005=\u0019#B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001eL!\u0001\u000b\u0010\u0003!I+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\u000f+\u0013\tYcD\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\bCA\u000f.\u0013\tqcD\u0001\fTG\",W.\u0019*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\ti\u0002'\u0003\u00022=\tI2I]3bi\u0006\u0014G.\u001a*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}Q\tA\u0007\u0005\u00026\u00015\ta\"A\u0005tQ>\u0014HOT1nKR\t\u0001\b\u0005\u0002:\u0001:\u0011!H\u0010\t\u0003wai\u0011\u0001\u0010\u0006\u0003{Q\ta\u0001\u0010:p_Rt\u0014BA \u0019\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011I\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}B\u0012AD2sK\u0006$XMU3mCRLwN\u001c\u000b\u0004\u000b\"s\u0005CA\u000fG\u0013\t9eD\u0001\u0007CCN,'+\u001a7bi&|g\u000eC\u0003J\u0007\u0001\u0007!*\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"a\u0013'\u000e\u0003\u0001J!!\u0014\u0011\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0003P\u0007\u0001\u0007\u0001+\u0001\u0006qCJ\fW.\u001a;feN\u0004B!O)9q%\u0011!K\u0011\u0002\u0004\u001b\u0006\u0004H\u0003B#U+ZCQ!\u0013\u0003A\u0002)CQa\u0014\u0003A\u0002ACQa\u0016\u0003A\u0002a\u000baa]2iK6\f\u0007CA-]\u001b\u0005Q&BA.!\u0003\u0015!\u0018\u0010]3t\u0013\ti&L\u0001\u0006TiJ,8\r\u001e+za\u0016$R!R0aK\u001aDQ!S\u0003A\u0002)CQ!Y\u0003A\u0002\t\fA!\\8eKB\u00111jY\u0005\u0003I\u0002\u0012\u0001bU1wK6{G-\u001a\u0005\u0006\u001f\u0016\u0001\r\u0001\u0015\u0005\u0006O\u0016\u0001\r\u0001[\u0001\u0005I\u0006$\u0018\r\u0005\u0002ji:\u0011!N\u001d\b\u0003WFt!\u0001\u001c9\u000f\u00055|gBA\u001eo\u0013\u00051\u0013B\u0001\u0013&\u0013\ty1%\u0003\u0002\"E%\u00111\u000fI\u0001\ba\u0006\u001c7.Y4f\u0013\t)hOA\u0005ECR\fgI]1nK*\u00111\u000fI\u0001\u0018O\u0016$8+\u001a7fGR4%o\\7UC\ndW-U;fef$\"\u0001O=\t\u000bi4\u0001\u0019\u0001\u001d\u0002\u0013Q\f'\r\\3OC6,\u0017!D:bm\u0016$\u0015\r^1Ge\u0006lW\rF\u0005~\u0003\u0003\t\u0019!a\u0002\u0002\nA\u0011qC`\u0005\u0003\u007fb\u0011A!\u00168ji\")\u0011j\u0002a\u0001\u0015\"1\u0011QA\u0004A\u0002!\f!\u0001\u001a4\t\u000bi<\u0001\u0019\u0001\u001d\t\u000f\u0005-q\u00011\u0001\u0002\u000e\u00059Q.\u00198bO\u0016\u0014\b\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005Ma\"\u0001\u0003vi&d\u0017\u0002BA\f\u0003#\u0011q#\u0012=bg>d7i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0002#\r\u0014X-\u0019;f\u000bb\f7o\u001c7UC\ndW\rF\u0004~\u0003;\ty\"!\t\t\r\u0005\u0015\u0001\u00021\u0001i\u0011\u0015Q\b\u00021\u00019\u0011\u001d\tY\u0001\u0003a\u0001\u0003\u001b\t!C]3qCJ$\u0018\u000e^5p]B+'OT8eKR)\u0001.a\n\u0002*!1\u0011QA\u0005A\u0002!Dq!a\u000b\n\u0001\u0004\ti#\u0001\u0005o_\u0012,7o\u00118u!\r9\u0012qF\u0005\u0004\u0003cA\"aA%oi\u0006Yq-\u001a;LKf4\u0016\r\\;f)\u0015A\u0014qGA\u001e\u0011\u0019\tID\u0003a\u0001q\u0005\u00191.Z=\t\u000b=S\u0001\u0019\u0001)\u0002\u001b\r\u0014X-\u0019;f\u001b\u0006t\u0017mZ3s)\u0019\ti!!\u0011\u0002D!)qj\u0003a\u0001!\")\u0011j\u0003a\u0001\u0015\u0006\u0019R.\u001a:hK\u000e{gNZ5hkJ\fG/[8ogR)\u0001+!\u0013\u0002L!)q\n\u0004a\u0001!\"1\u0011Q\n\u0007A\u0002A\u000b\u0011b\u001d9be.\u001cuN\u001c4")
public class DefaultSource
implements RelationProvider,
DataSourceRegister,
SchemaRelationProvider,
CreatableRelationProvider {
    public String shortName() {
        return "exasol";
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        String queryString = this.getKeyValue("query", parameters);
        ExasolConnectionManager manager = this.createManager(parameters, sqlContext);
        return new ExasolRelation(sqlContext, queryString, (Option<StructType>)None$.MODULE$, manager);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        String queryString = this.getKeyValue("query", parameters);
        ExasolConnectionManager manager = this.createManager(parameters, sqlContext);
        return new ExasolRelation(sqlContext, queryString, (Option<StructType>)Option$.MODULE$.apply((Object)schema), manager);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        String tableName = this.getKeyValue("table", parameters);
        ExasolConnectionManager manager = this.createManager(parameters, sqlContext);
        if (manager.config().drop_table()) {
            manager.dropTable(tableName);
        }
        boolean isTableExist = manager.tableExists(tableName);
        SaveMode saveMode = mode;
        if (SaveMode.Overwrite.equals(saveMode)) {
            if (!isTableExist) {
                this.createExasolTable(data, tableName, manager);
            }
            manager.truncateTable(tableName);
            this.saveDataFrame(sqlContext, data, tableName, manager);
        } else if (SaveMode.Append.equals(saveMode)) {
            if (!isTableExist) {
                this.createExasolTable(data, tableName, manager);
            }
            this.saveDataFrame(sqlContext, data, tableName, manager);
        } else if (SaveMode.ErrorIfExists.equals(saveMode)) {
            if (isTableExist) {
                throw new UnsupportedOperationException(ExaError.messageBuilder((String)"E-SEC-3").message("Table {{TABLE}} already exists in 'errorifexists' or 'default' write modes.", new Object[]{tableName}).mitigation("Please use one of the following write modes: 'append', 'overwrite', 'ignore'.", new Object[0]).toString());
            }
            this.createExasolTable(data, tableName, manager);
            this.saveDataFrame(sqlContext, data, tableName, manager);
        } else if (SaveMode.Ignore.equals(saveMode)) {
            if (!isTableExist) {
                this.createExasolTable(data, tableName, manager);
                this.saveDataFrame(sqlContext, data, tableName, manager);
            }
        } else {
            throw new MatchError((Object)saveMode);
        }
        Map newParams = parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"query"), (Object)this.getSelectFromTableQuery(tableName))})));
        return this.createRelation(sqlContext, (Map<String, String>)newParams, data.schema());
    }

    private String getSelectFromTableQuery(String tableName) {
        FromClause select = StatementFactory.getInstance().select().all().from().table(tableName);
        StringRendererConfig rendererConfig = StringRendererConfig.builder().quoteIdentifiers(true).build();
        SelectRenderer renderer = new SelectRenderer(rendererConfig);
        select.accept((SelectVisitor)renderer);
        return renderer.render();
    }

    private void saveDataFrame(SQLContext sqlContext, Dataset<Row> df, String tableName, ExasolConnectionManager manager) {
        ExasolWriter writer = new ExasolWriter(sqlContext.sparkContext(), tableName, df.schema(), manager);
        int exaNodesCnt = writer.startParallel();
        Dataset<Row> newDF = this.repartitionPerNode(df, exaNodesCnt);
        newDF.rdd().foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
            writer.insertPartition((Iterator<Row>)iter);
            return BoxedUnit.UNIT;
        });
    }

    private void createExasolTable(Dataset<Row> df, String tableName, ExasolConnectionManager manager) {
        if (manager.config().create_table() || manager.config().drop_table()) {
            manager.createTable(tableName, Types$.MODULE$.createTableSchema(df.schema()));
            return;
        }
        throw new UnsupportedOperationException(ExaError.messageBuilder((String)"E-SEC-2").message("Table {{TABLE}} does not exist.", new Object[]{tableName}).mitigation("Please create table beforehand or enable table creation by setting 'create_table' option.", new Object[0]).toString());
    }

    public Dataset<Row> repartitionPerNode(Dataset<Row> df, int nodesCnt) {
        int rddPartitionCnt = df.rdd().getNumPartitions();
        if (nodesCnt < rddPartitionCnt) {
            return df.coalesce(nodesCnt);
        }
        if (nodesCnt > rddPartitionCnt) {
            return df.repartition(nodesCnt);
        }
        return df;
    }

    private String getKeyValue(String key, Map<String, String> parameters) {
        Option option = parameters.get((Object)key);
        if (option instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            return str;
        }
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedOperationException(ExaError.messageBuilder((String)"E-SEC-1").message("Parameter {{PARAMETER}} is missing.", new Object[]{key}).mitigation("Please provide required parameter.", new Object[0]).toString());
        }
        throw new MatchError((Object)option);
    }

    private ExasolConnectionManager createManager(Map<String, String> parameters, SQLContext sqlContext) {
        ExasolConfiguration config = ExasolConfiguration$.MODULE$.apply(this.mergeConfigurations(parameters, (Map<String, String>)sqlContext.getAllConfs()));
        return new ExasolConnectionManager(config);
    }

    public Map<String, String> mergeConfigurations(Map<String, String> parameters, Map<String, String> sparkConf) {
        return parameters.$plus$plus((GenTraversableOnce)((TraversableLike)sparkConf.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$mergeConfigurations$1(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.substring("spark.exasol.".length())), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$mergeConfigurations$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return key.startsWith("spark.exasol.");
        }
        throw new MatchError((Object)tuple2);
    }
}

