/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.util;

import com.exasol.errorreporting.ExaError;
import com.exasol.spark.util.ExasolConfiguration;
import java.net.InetAddress;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple10;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ExasolConfiguration$
implements Serializable {
    public static ExasolConfiguration$ MODULE$;
    private final String IPv4_DIGITS;
    private final Regex IPv4_REGEX;
    private final String DEFAULT_MAX_NODES;
    private final String DEFAULT_BATCH_SIZE;
    private volatile byte bitmap$init$0;

    static {
        new ExasolConfiguration$();
    }

    public ExasolConfiguration apply(Map<String, String> options) {
        String host = (String)options.getOrElse((Object)"host", (Function0 & java.io.Serializable & Serializable)() -> MODULE$.getLocalHost());
        String jdbc_options = (String)options.getOrElse((Object)"jdbc_options", (Function0 & java.io.Serializable & Serializable)() -> "");
        this.checkHost(host);
        this.checkJdbcOptions(jdbc_options);
        return new ExasolConfiguration(host, new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"port", (Function0 & java.io.Serializable & Serializable)() -> "8888"))).toInt(), jdbc_options, (String)options.getOrElse((Object)"username", (Function0 & java.io.Serializable & Serializable)() -> "sys"), (String)options.getOrElse((Object)"password", (Function0 & java.io.Serializable & Serializable)() -> "exasol"), (String)options.getOrElse((Object)"fingerprint", (Function0 & java.io.Serializable & Serializable)() -> ""), new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"max_nodes", (Function0 & java.io.Serializable & Serializable)() -> ExasolConfiguration$.MODULE$.DEFAULT_MAX_NODES))).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"create_table", (Function0 & java.io.Serializable & Serializable)() -> "false"))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"drop_table", (Function0 & java.io.Serializable & Serializable)() -> "false"))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"batch_size", (Function0 & java.io.Serializable & Serializable)() -> ExasolConfiguration$.MODULE$.DEFAULT_BATCH_SIZE))).toInt());
    }

    private String getLocalHost() {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public String checkHost(String host) {
        String string = host;
        Option option = this.IPv4_REGEX.unapplySeq((CharSequence)string);
        if (!option.isEmpty()) {
            return host;
        }
        throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-SEC-4").message("The host value is not an IPv4 address.", new Object[0]).mitigation("The host value should be an IPv4 address of the first Exasol datanode.", new Object[0]).toString());
    }

    private void checkJdbcOptions(String options) {
        this.checkStartsOrEndsWith(options, ";");
        if (!options.isEmpty()) {
            String[] keyValuePairs = options.split(";");
            this.checkContainsKeyValuePairs(keyValuePairs, "=");
            return;
        }
    }

    private void checkStartsOrEndsWith(String input, String pattern) {
        if (input.endsWith(pattern) || input.startsWith(pattern)) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-SEC-5").message("JDBC options should not start or end with semicolon.", new Object[0]).mitigation("Please remove from beginning or end of JDBC options.", new Object[0]).toString());
        }
    }

    private void checkContainsKeyValuePairs(String[] options, String pattern) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])options)).foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            ExasolConfiguration$.$anonfun$checkContainsKeyValuePairs$1(pattern, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public ExasolConfiguration apply(String host, int port, String jdbc_options, String username, String password, String fingerprint, int max_nodes, boolean create_table, boolean drop_table, int batch_size) {
        return new ExasolConfiguration(host, port, jdbc_options, username, password, fingerprint, max_nodes, create_table, drop_table, batch_size);
    }

    public Option<Tuple10<String, Object, String, String, String, String, Object, Object, Object, Object>> unapply(ExasolConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple10((Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.jdbc_options(), (Object)x$0.username(), (Object)x$0.password(), (Object)x$0.fingerprint(), (Object)BoxesRunTime.boxToInteger((int)x$0.max_nodes()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.create_table()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.drop_table()), (Object)BoxesRunTime.boxToInteger((int)x$0.batch_size())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$checkContainsKeyValuePairs$1(String pattern$1, String x0$1) {
        String string = x0$1;
        if (string.split(pattern$1).length != 2) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-SEC-6").message("Parameter {{PARAMETER}} does not have key=value format.", new Object[]{string}).mitigation("Please make sure parameters are encoded as key=value pairs.", new Object[0]).toString());
        }
    }

    private ExasolConfiguration$() {
        MODULE$ = this;
        this.IPv4_DIGITS = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.IPv4_REGEX = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(8).append("^").append(this.IPv4_DIGITS).append("\\.").append(this.IPv4_DIGITS).append("\\.").append(this.IPv4_DIGITS).append("\\.").append(this.IPv4_DIGITS).append("$").toString())).r();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.DEFAULT_MAX_NODES = "200";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.DEFAULT_BATCH_SIZE = "1000";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

