/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.spark.writer;

import com.exasol.errorreporting.ExaError;
import com.exasol.jdbc.EXAConnection;
import com.exasol.spark.util.Converter$;
import com.exasol.spark.util.ExasolConnectionManager;
import com.exasol.spark.util.Types$;
import java.io.Serializable;
import java.sql.PreparedStatement;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\t\u0013\u0001mA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\ta\u0001\u0011\t\u0011)A\u0005O!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\"B)\u0001\t\u0003\u0011\u0006bB-\u0001\u0001\u0004%IA\u0017\u0005\bC\u0002\u0001\r\u0011\"\u0003c\u0011\u0019A\u0007\u0001)Q\u00057\"9!\u000e\u0001a\u0001\n\u0013Y\u0007bB;\u0001\u0001\u0004%IA\u001e\u0005\u0007q\u0002\u0001\u000b\u0015\u00027\t\u000be\u0004A\u0011\u0001>\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d!\u0001D#yCN|Gn\u0016:ji\u0016\u0014(BA\n\u0015\u0003\u00199(/\u001b;fe*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u001a=bg>d'\"A\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003;\rJ!\u0001\n\u0010\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0005M\u001cW#A\u0014\u0011\u0005!rS\"A\u0015\u000b\u0005UQ#BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001eL!aL\u0015\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\u0007M\u001c\u0007\u0005\u000b\u0002\u0003eA\u0011QdM\u0005\u0003iy\u0011\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0013Q\f'\r\\3OC6,\u0007CA\u001c?\u001d\tAD\b\u0005\u0002:=5\t!H\u0003\u0002<5\u00051AH]8pizJ!!\u0010\u0010\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{y\t\u0011B\u001d3e'\u000eDW-\\1\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015!\u0002;za\u0016\u001c(BA$*\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u0013\u0012\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003\u001di\u0017M\\1hKJ\u0004\"\u0001T(\u000e\u00035S!A\u0014\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003!6\u0013q#\u0012=bg>d7i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u0015\u0019VKV,Y!\t!\u0006!D\u0001\u0013\u0011\u0015)c\u00011\u0001(\u0011\u0015)d\u00011\u00017\u0011\u0015\te\u00011\u0001C\u0011\u0015Qe\u00011\u0001L\u00039i\u0017-\u001b8D_:tWm\u0019;j_:,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=Z\tAA\u001b3cG&\u0011\u0001-\u0018\u0002\u000e\u000bb\u000b5i\u001c8oK\u000e$\u0018n\u001c8\u0002%5\f\u0017N\\\"p]:,7\r^5p]~#S-\u001d\u000b\u0003G\u001a\u0004\"!\b3\n\u0005\u0015t\"\u0001B+oSRDqa\u001a\u0005\u0002\u0002\u0003\u00071,A\u0002yIE\nq\"\\1j]\u000e{gN\\3di&|g\u000e\t\u0015\u0003\u0013I\nQ\u0001[8tiN,\u0012\u0001\u001c\t\u0004[J4dB\u00018q\u001d\tIt.C\u0001 \u0013\t\th$A\u0004qC\u000e\\\u0017mZ3\n\u0005M$(aA*fc*\u0011\u0011OH\u0001\nQ>\u001cHo]0%KF$\"aY<\t\u000f\u001d\\\u0011\u0011!a\u0001Y\u00061\u0001n\\:ug\u0002\n!c\u00197pg\u0016l\u0015-\u001b8SKN|WO]2fgR\t1-A\u0007ti\u0006\u0014H\u000fU1sC2dW\r\u001c\u000b\u0002{B\u0011QD`\u0005\u0003\u007fz\u00111!\u00138u\u0003)Ign]3siN#X\u000e\u001e\u000b\u0002m\u0005y\u0011N\\:feR\u0004\u0016M\u001d;ji&|g\u000eF\u0002d\u0003\u0013Aq!a\u0003\u0011\u0001\u0004\ti!\u0001\u0003ji\u0016\u0014\b#B7\u0002\u0010\u0005M\u0011bAA\ti\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002\u0016\u0005]Q\"\u0001$\n\u0007\u0005eaIA\u0002S_^\u0004")
public class ExasolWriter
implements scala.Serializable {
    private final transient SparkContext sc;
    private final String tableName;
    private final StructType rddSchema;
    private final ExasolConnectionManager manager;
    private transient EXAConnection mainConnection;
    private Seq<String> hosts;
    private volatile transient boolean bitmap$inittrans$0;
    private volatile boolean bitmap$init$0;

    public SparkContext sc() {
        return this.sc;
    }

    private EXAConnection mainConnection() {
        if (!this.bitmap$inittrans$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/ExasolWriter.scala: 27");
        }
        return this.mainConnection;
    }

    private void mainConnection_$eq(EXAConnection x$1) {
        this.mainConnection = x$1;
        this.bitmap$inittrans$0 = true;
    }

    private Seq<String> hosts() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/spark-connector/spark-connector/src/main/scala/com/exasol/spark/ExasolWriter.scala: 28");
        }
        return this.hosts;
    }

    private void hosts_$eq(Seq<String> x$1) {
        this.hosts = x$1;
        this.bitmap$init$0 = true;
    }

    public void closeMainResources() {
        if (this.mainConnection() != null && !this.mainConnection().isClosed()) {
            this.mainConnection().close();
            return;
        }
    }

    public int startParallel() {
        this.mainConnection_$eq(this.manager.writerMainConnection());
        if (this.mainConnection() == null) {
            throw new RuntimeException(ExaError.messageBuilder((String)"F-SEC-7").message("Could not create main JDBC connection to Exasol cluster.", new Object[0]).mitigation("Please make sure that there network connection between Spark and Exasol clusters.", new Object[0]).toString());
        }
        int cnt = this.manager.initParallel(this.mainConnection());
        this.sc().addSparkListener((SparkListenerInterface)new SparkListener(this){
            private final /* synthetic */ ExasolWriter $outer;

            public void onApplicationEnd(SparkListenerApplicationEnd appEnd) {
                this.$outer.closeMainResources();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.hosts_$eq(this.manager.subConnections(this.mainConnection()));
        return cnt;
    }

    public String insertStmt() {
        String columns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rddSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        String placeholders = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rddSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> "?", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        return new StringBuilder(25).append("INSERT INTO ").append(this.tableName).append(" (").append(columns).append(") VALUES (").append(placeholders).append(")").toString();
    }

    public void insertPartition(Iterator<Row> iter) {
        int partitionId = TaskContext$.MODULE$.getPartitionId();
        String subConnectionUrl = (String)this.hosts().apply(partitionId);
        EXAConnection subConn = this.manager.subConnection(subConnectionUrl);
        PreparedStatement stmt = subConn.prepareStatement(this.insertStmt());
        Function3[] setters = (Function3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rddSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> Converter$.MODULE$.makeSetter(f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)));
        int[] nullTypes = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rddSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)Types$.MODULE$.jdbcTypeFromSparkDataType(f.dataType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        int fieldCnt = this.rddSchema.fields().length;
        int batchSize = this.manager.config().batch_size();
        try {
            int rowCnt = 0;
            int totalCnt = 0;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                for (int i = 0; i < fieldCnt; ++i) {
                    Object object;
                    if (row.isNullAt(i)) {
                        stmt.setNull(i + 1, nullTypes[i]);
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    object = setters[i].apply((Object)stmt, (Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                }
                stmt.addBatch();
                if (++rowCnt % batchSize != 0) continue;
                int[] _ = stmt.executeBatch();
                totalCnt += rowCnt;
                rowCnt = 0;
            }
            if (rowCnt > 0) {
                int[] _ = stmt.executeBatch();
                totalCnt += rowCnt;
            }
        }
        finally {
            stmt.close();
            subConn.commit();
            subConn.close();
        }
    }

    public ExasolWriter(SparkContext sc, String tableName, StructType rddSchema, ExasolConnectionManager manager) {
        this.sc = sc;
        this.tableName = tableName;
        this.rddSchema = rddSchema;
        this.manager = manager;
        this.mainConnection = null;
        this.bitmap$inittrans$0 = true;
        this.hosts = null;
        this.bitmap$init$0 = true;
    }
}

