/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql;

import com.exasol.datatype.type.Boolean;
import com.exasol.datatype.type.Char;
import com.exasol.datatype.type.DataType;
import com.exasol.datatype.type.Date;
import com.exasol.datatype.type.Decimal;
import com.exasol.datatype.type.DoublePrecision;
import com.exasol.datatype.type.IntervalDayToSecond;
import com.exasol.datatype.type.IntervalYearToMonth;
import com.exasol.datatype.type.Timestamp;
import com.exasol.datatype.type.TimestampWithLocalTimezone;
import com.exasol.datatype.type.Varchar;
import com.exasol.sql.AbstractFragment;
import com.exasol.sql.Column;
import com.exasol.sql.ColumnDefinitionVisitor;
import com.exasol.sql.SqlStatement;
import java.util.ArrayList;
import java.util.List;

public class ColumnsDefinition
extends AbstractFragment {
    private List<Column> columns = new ArrayList<Column>();

    public ColumnsDefinition(SqlStatement root) {
        super(root);
    }

    public ColumnsDefinition(List<Column> columns) {
        super(null);
        this.columns = columns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void add(String name, DataType dataType) {
        this.columns.add(new Column(this, name, dataType));
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void accept(ColumnDefinitionVisitor visitor) {
        visitor.visit(this);
    }

    public static class Builder {
        private final List<Column> columns = new ArrayList<Column>();

        public Builder booleanColumn(String columnName) {
            this.columns.add(new Column(null, columnName, new Boolean()));
            return this;
        }

        public Builder charColumn(String columnName, int length) {
            this.columns.add(new Column(null, columnName, new Char(length)));
            return this;
        }

        public Builder varcharColumn(String columnName, int length) {
            this.columns.add(new Column(null, columnName, new Varchar(length)));
            return this;
        }

        public Builder dateColumn(String columnName) {
            this.columns.add(new Column(null, columnName, new Date()));
            return this;
        }

        public Builder decimalColumn(String columnName, int precision, int scale) {
            this.columns.add(new Column(null, columnName, new Decimal(precision, scale)));
            return this;
        }

        public Builder doublePrecisionColumn(String columnName) {
            this.columns.add(new Column(null, columnName, new DoublePrecision()));
            return this;
        }

        public Builder timestampColumn(String columnName) {
            this.columns.add(new Column(null, columnName, new Timestamp()));
            return this;
        }

        public Builder timestampWithLocalTimeZoneColumn(String columnName) {
            this.columns.add(new Column(null, columnName, new TimestampWithLocalTimezone()));
            return this;
        }

        public Builder intervalDayToSecondColumn(String columnName, int yearPrecision, int millisecondPrecision) {
            this.columns.add(new Column(null, columnName, new IntervalDayToSecond(yearPrecision, millisecondPrecision)));
            return this;
        }

        public Builder intervalYearToMonthColumn(String columnName, int yearPrecision) {
            this.columns.add(new Column(null, columnName, new IntervalYearToMonth(yearPrecision)));
            return this;
        }

        public ColumnsDefinition build() {
            return new ColumnsDefinition(this.columns);
        }
    }
}

