/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql;

import com.exasol.sql.AbstractFragment;
import com.exasol.sql.Fragment;
import com.exasol.sql.ValueTableRow;
import com.exasol.sql.ValueTableVisitor;
import com.exasol.sql.expression.ValueExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ValueTable
extends AbstractFragment {
    private final List<ValueTableRow> rows = new ArrayList<ValueTableRow>();
    private String tableNameAlias;
    private final List<String> columnNameAliases = new ArrayList<String>();

    public ValueTable(Fragment root) {
        super(root);
    }

    public ValueTable appendRow(String ... literals) {
        this.rows.add(new ValueTableRow(this.root, literals));
        return this;
    }

    public ValueTable appendRow(ValueTableRow row) {
        this.rows.add(row);
        return this;
    }

    public List<ValueTableRow> getRows() {
        return this.rows;
    }

    public void add(String ... values) {
        this.amendLastRow(this.createLastRowBuilder().add(values).build());
    }

    public void add(char ... values) {
        this.amendLastRow(this.createLastRowBuilder().add(values).build());
    }

    private synchronized void amendLastRow(ValueTableRow row) {
        if (this.isEmpty()) {
            this.rows.add(row);
        } else {
            this.rows.set(this.rows.size() - 1, row);
        }
    }

    private ValueTableRow.Builder createLastRowBuilder() {
        ValueTableRow.Builder builder = ValueTableRow.builder(this.root);
        if (!this.isEmpty()) {
            builder.add(this.getLastRow().getExpressions());
        }
        return builder;
    }

    public void add(int ... values) {
        this.amendLastRow(this.createLastRowBuilder().add(values).build());
    }

    public void add(long ... values) {
        this.amendLastRow(this.createLastRowBuilder().add(values).build());
    }

    public void add(double ... values) {
        this.amendLastRow(this.createLastRowBuilder().add(values).build());
    }

    public void add(float ... values) {
        this.amendLastRow(this.createLastRowBuilder().add(values).build());
    }

    public void add(boolean ... values) {
        this.amendLastRow(this.createLastRowBuilder().add(values).build());
    }

    public void addPlaceholder() {
        this.amendLastRow(this.createLastRowBuilder().addPlaceholder().build());
    }

    public void add(ValueExpression ... expressions) {
        this.amendLastRow(this.createLastRowBuilder().add(Arrays.asList(expressions)).build());
    }

    private ValueTableRow getLastRow() {
        return this.rows.get(this.rows.size() - 1);
    }

    protected boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public void accept(ValueTableVisitor visitor) {
        visitor.visit(this);
        for (ValueTableRow row : this.rows) {
            row.accept(visitor);
        }
        visitor.leave(this);
    }

    public void alias(String tableNameAlias, String ... columnNameAliases) {
        this.tableNameAlias = tableNameAlias;
        if (columnNameAliases.length > 0) {
            this.columnNameAliases.addAll(Arrays.asList(columnNameAliases));
        }
    }

    public boolean hasAlias() {
        return this.tableNameAlias != null && !this.tableNameAlias.isEmpty() && !this.columnNameAliases.isEmpty();
    }

    public String getTableNameAlias() {
        return this.tableNameAlias;
    }

    public List<String> getColumnNameAliases() {
        return this.columnNameAliases;
    }
}

