/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.dml.insert.rendering;

import com.exasol.sql.DerivedColumn;
import com.exasol.sql.SqlStatement;
import com.exasol.sql.Table;
import com.exasol.sql.ValueTable;
import com.exasol.sql.ValueTableRow;
import com.exasol.sql.dml.insert.InsertFields;
import com.exasol.sql.dml.insert.InsertVisitor;
import com.exasol.sql.rendering.AbstractFragmentRenderer;
import com.exasol.sql.rendering.StringRendererConfig;

public class InsertRenderer
extends AbstractFragmentRenderer
implements InsertVisitor {
    public InsertRenderer(StringRendererConfig config) {
        super(config);
    }

    @Override
    public void visit(SqlStatement insert) {
        this.appendKeyWord("INSERT INTO ");
        this.setLastVisited(insert);
    }

    @Override
    public void visit(Table table) {
        this.appendAutoQuoted(table.getName());
        this.setLastVisited(table);
    }

    @Override
    public void visit(DerivedColumn derivedColumn) {
        this.appendCommaWhenNeeded(derivedColumn);
        this.appendRenderedValueExpression(derivedColumn.getValueExpression());
        this.setLastVisited(derivedColumn);
    }

    @Override
    public void visit(InsertFields insertFields) {
        this.append(" (");
        this.setLastVisited(insertFields);
    }

    @Override
    public void leave(InsertFields insertFields) {
        this.append(")");
    }

    @Override
    public void visit(ValueTable valueTable) {
        this.appendKeyWord(" VALUES ");
        this.setLastVisited(valueTable);
    }

    @Override
    public void leave(ValueTable valueTable) {
        this.setLastVisited(valueTable);
    }

    @Override
    public void visit(ValueTableRow valueTableRow) {
        this.appendCommaWhenNeeded(valueTableRow);
        this.append("(");
        this.appendValueTableRow(valueTableRow);
        this.setLastVisited(valueTableRow);
    }

    @Override
    public void leave(ValueTableRow valueTableRow) {
        this.append(")");
        this.setLastVisited(valueTableRow);
    }

    public static InsertRenderer create() {
        return InsertRenderer.create(StringRendererConfig.createDefault());
    }

    public static InsertRenderer create(StringRendererConfig config) {
        return new InsertRenderer(config);
    }
}

