/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.dql.select;

import com.exasol.sql.AbstractFragment;
import com.exasol.sql.Fragment;
import com.exasol.sql.Table;
import com.exasol.sql.ValueTable;
import com.exasol.sql.dql.select.Join;
import com.exasol.sql.dql.select.JoinType;
import com.exasol.sql.dql.select.Select;
import com.exasol.sql.dql.select.SelectFragment;
import com.exasol.sql.dql.select.SelectVisitor;
import java.util.ArrayList;
import java.util.List;

public class FromClause
extends AbstractFragment
implements SelectFragment {
    private final List<Table> tables = new ArrayList<Table>();
    private final List<Join> joins = new ArrayList<Join>();
    private final List<ValueTable> valueTables = new ArrayList<ValueTable>();
    private Select subSelect;

    public FromClause(Fragment root) {
        super(root);
    }

    public FromClause table(String name) {
        this.tables.add(new Table(this.getRoot(), name));
        return this;
    }

    public FromClause tableAs(String name, String as) {
        this.tables.add(new Table(this.getRoot(), name, as));
        return this;
    }

    public FromClause valueTable(ValueTable valueTable) {
        this.valueTables.add(valueTable);
        return this;
    }

    public FromClause valueTableAs(ValueTable valueTable, String tableNameAlias, String ... columnNameAliases) {
        valueTable.alias(tableNameAlias, columnNameAliases);
        this.valueTables.add(valueTable);
        return this;
    }

    public FromClause join(String name, String specification) {
        this.joins.add(new Join(this.getRoot(), JoinType.DEFAULT, name, specification));
        return this;
    }

    public FromClause innerJoin(String name, String specification) {
        this.joins.add(new Join(this.getRoot(), JoinType.INNER, name, specification));
        return this;
    }

    public FromClause leftJoin(String name, String specification) {
        this.joins.add(new Join(this.getRoot(), JoinType.LEFT, name, specification));
        return this;
    }

    public FromClause rightJoin(String name, String specification) {
        this.joins.add(new Join(this.getRoot(), JoinType.RIGHT, name, specification));
        return this;
    }

    public FromClause fullJoin(String name, String specification) {
        this.joins.add(new Join(this.getRoot(), JoinType.FULL, name, specification));
        return this;
    }

    public FromClause leftOuterJoin(String name, String specification) {
        this.joins.add(new Join(this.getRoot(), JoinType.LEFT_OUTER, name, specification));
        return this;
    }

    public FromClause rightOuterJoin(String name, String specification) {
        this.joins.add(new Join(this.getRoot(), JoinType.RIGHT_OUTER, name, specification));
        return this;
    }

    public FromClause fullOuterJoin(String name, String specification) {
        this.joins.add(new Join(this.getRoot(), JoinType.FULL_OUTER, name, specification));
        return this;
    }

    public FromClause select(Select select) {
        this.subSelect = select;
        return this;
    }

    public boolean hasSubSelect() {
        return this.subSelect != null;
    }

    @Override
    public void accept(SelectVisitor visitor) {
        visitor.visit(this);
        if (this.hasSubSelect()) {
            this.subSelect.accept(visitor);
        }
        for (Table table : this.tables) {
            table.accept(visitor);
        }
        for (Join join : this.joins) {
            join.accept(visitor);
        }
        for (ValueTable valueTable : this.valueTables) {
            if (this.hasSubSelect()) {
                throw new IllegalArgumentException("SELECT statement cannot combine sub-select and value table.");
            }
            valueTable.accept(visitor);
        }
        visitor.leave(this);
    }
}

