/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression;

import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.ValueExpressionVisitor;

public final class ColumnReference
implements ValueExpression {
    private final String columnName;
    private final String tableName;

    private ColumnReference(String columnName, String tableName) {
        this.columnName = columnName;
        this.tableName = tableName;
    }

    public static ColumnReference column(String tableName, String columnName) {
        return new ColumnReference(columnName, tableName);
    }

    public static ColumnReference of(String columnName) {
        return new ColumnReference(columnName, null);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.tableName != null && !this.tableName.isEmpty()) {
            stringBuilder.append(this.tableName);
            stringBuilder.append(".");
        }
        stringBuilder.append(this.columnName);
        return stringBuilder.toString();
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

