/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.rendering;

import com.exasol.sql.expression.literal.BooleanLiteral;
import com.exasol.sql.rendering.StringRendererConfig;
import com.exasol.util.QuotesApplier;

public abstract class AbstractExpressionRenderer {
    protected final StringRendererConfig config;
    protected final StringBuilder builder = new StringBuilder();
    private final QuotesApplier quotesApplier;

    protected AbstractExpressionRenderer(StringRendererConfig config) {
        this.config = config;
        this.quotesApplier = new QuotesApplier(config);
    }

    protected void appendKeyword(String keyword) {
        this.builder.append(this.config.useLowerCase() ? keyword.toLowerCase() : keyword);
    }

    protected void appendBooleanLiteral(BooleanLiteral literal) {
        this.builder.append(this.config.useLowerCase() ? literal.toString().toLowerCase() : literal.toString());
    }

    protected void startParenthesis() {
        this.builder.append("(");
    }

    protected void endParenthesis() {
        this.builder.append(")");
    }

    protected void append(String string) {
        this.builder.append(string);
    }

    protected void appendAutoQuoted(String identifier) {
        String autoQuotedIdentifier = this.quotesApplier.getAutoQuoted(identifier);
        this.append(autoQuotedIdentifier);
    }

    public String render() {
        return this.builder.toString();
    }
}

