/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.rendering;

import com.exasol.sql.Fragment;
import com.exasol.sql.ValueTableRow;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.rendering.ValueExpressionRenderer;
import com.exasol.sql.rendering.FragmentRenderer;
import com.exasol.sql.rendering.StringRendererConfig;
import com.exasol.util.QuotesApplier;
import java.util.List;

public abstract class AbstractFragmentRenderer
implements FragmentRenderer {
    protected final StringRendererConfig config;
    private final StringBuilder builder = new StringBuilder();
    private Fragment lastVisited;
    private final QuotesApplier quotesApplier;

    protected AbstractFragmentRenderer(StringRendererConfig config) {
        this.config = config;
        this.lastVisited = null;
        this.quotesApplier = new QuotesApplier(config);
    }

    protected void appendKeyWord(String keyword) {
        this.append(this.config.useLowerCase() ? keyword.toLowerCase() : keyword);
    }

    protected void startParenthesis() {
        this.builder.append("(");
    }

    protected void endParenthesis() {
        this.builder.append(")");
    }

    protected void appendRenderedValueExpression(ValueExpression expression) {
        ValueExpressionRenderer renderer = new ValueExpressionRenderer(this.config);
        expression.accept(renderer);
        this.append(renderer.render());
    }

    protected void appendListOfValueExpressions(List<? extends ValueExpression> valueExpressions) {
        if (valueExpressions != null && !valueExpressions.isEmpty()) {
            ValueExpressionRenderer valueExpressionRenderer = new ValueExpressionRenderer(this.config);
            valueExpressionRenderer.visit((ValueExpression[])valueExpressions.toArray(ValueExpression[]::new));
            this.builder.append(valueExpressionRenderer.render());
        }
    }

    protected StringBuilder append(String string) {
        return this.builder.append(string);
    }

    protected void setLastVisited(Fragment fragment) {
        this.lastVisited = fragment;
    }

    protected void appendSpace() {
        this.append(" ");
    }

    protected void appendCommaWhenNeeded(Fragment fragment) {
        if (this.lastVisited != null && this.lastVisited.getClass().equals(fragment.getClass())) {
            this.append(", ");
        }
    }

    protected void append(int number) {
        this.builder.append(number);
    }

    protected void appendAutoQuoted(String identifier) {
        String autoQuotedIdentifier = this.quotesApplier.getAutoQuoted(identifier);
        this.append(autoQuotedIdentifier);
    }

    protected void appendValueTableRow(ValueTableRow valueTableRow) {
        boolean first = true;
        for (ValueExpression expression : valueTableRow.getExpressions()) {
            if (first) {
                first = false;
            } else {
                this.append(", ");
            }
            this.appendRenderedValueExpression(expression);
        }
    }

    @Override
    public String render() {
        return this.builder.toString();
    }
}

