/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;

public final class FileKey
implements SecretKey {
    private static final String ALGORITHM = "age-encryption.org";
    private static final String FORMAT = "RAW";
    private static final int KEY_LENGTH = 16;
    private static final byte ZERO = 0;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final byte[] key;

    public FileKey() {
        this.key = FileKey.getSecureRandomKey();
    }

    public FileKey(byte[] key) {
        this.key = FileKey.getValidatedKey(key);
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public void destroy() {
        Arrays.fill(this.key, (byte)0);
        this.destroyed.set(true);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public boolean equals(Object object) {
        boolean equals;
        if (object instanceof FileKey) {
            FileKey otherFileKey = (FileKey)object;
            equals = MessageDigest.isEqual(this.key, otherFileKey.key);
        } else {
            equals = false;
        }
        return equals;
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    private static byte[] getSecureRandomKey() {
        byte[] key = new byte[16];
        SECURE_RANDOM.nextBytes(key);
        return key;
    }

    private static byte[] getValidatedKey(byte[] key) {
        Objects.requireNonNull(key, "File Key required");
        if (key.length == 16) {
            return key;
        }
        String message = String.format("File Key Length [%d] not equal to required length [%d]", key.length, 16);
        throw new IllegalArgumentException(message);
    }
}

