/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.bech32;

import com.exceptionfactory.jagged.bech32.Bech32;
import com.exceptionfactory.jagged.bech32.SharedCoder;
import java.io.CharArrayWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Objects;

class StandardEncoder
extends SharedCoder
implements Bech32.Encoder {
    StandardEncoder() {
    }

    @Override
    public CharSequence encode(CharSequence humanReadablePart, byte[] data) {
        CharSequence validatedHumanReadablePart = this.getHumanReadablePartValidated(humanReadablePart);
        Objects.requireNonNull(data, "Data required");
        boolean upperCaseRequired = this.isUpperCaseRequired(humanReadablePart);
        CharArrayWriter writer = new CharArrayWriter();
        writer.append(validatedHumanReadablePart);
        writer.append('1');
        byte[] dataConverted = this.getDataConverted(data, SharedCoder.ConversionMode.ENCODING);
        this.appendEncoded(writer, dataConverted);
        byte[] checksum = this.getChecksum(validatedHumanReadablePart, dataConverted);
        this.appendEncoded(writer, checksum);
        return this.getEncoded(writer, upperCaseRequired);
    }

    private CharSequence getEncoded(CharArrayWriter writer, boolean upperCaseRequired) {
        CharBuffer lowerCaseEncoded = CharBuffer.wrap(writer.toCharArray());
        CharSequence encoded = upperCaseRequired ? this.getUpperCase(lowerCaseEncoded) : lowerCaseEncoded;
        return encoded;
    }

    private CharSequence getUpperCase(CharBuffer buffer) {
        char[] characters = buffer.array();
        for (int i = 0; i < characters.length; ++i) {
            char character = characters[i];
            characters[i] = Character.toUpperCase(character);
        }
        return buffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUpperCaseRequired(CharSequence humanReadablePart) {
        if (!this.hasUpperCaseCharacters(humanReadablePart)) return false;
        if (!this.isUpperCase(humanReadablePart)) throw new IllegalArgumentException("Encoded Bech32 string must be lowercase or uppercase not mixed");
        return true;
    }

    private void appendEncoded(CharArrayWriter writer, byte[] values) {
        for (byte value : values) {
            char valueEncoded = "qpzry9x8gf2tvdw0s3jn54khce6mua7l".charAt(value);
            writer.append(valueEncoded);
        }
    }

    private byte[] getChecksum(CharSequence humanReadablePart, byte[] data) {
        byte[] humanReadablePartExpanded = this.getHumanReadablePartExpanded(humanReadablePart);
        byte[] emptyChecksum = new byte[6];
        int polynomialModulus = this.getPolynomialModulus(humanReadablePartExpanded, data, emptyChecksum);
        int modulus = polynomialModulus ^ 1;
        ByteBuffer checksumBuffer = ByteBuffer.allocate(6);
        for (int i = 0; i < 6; ++i) {
            int shift = 5 * (5 - i);
            int checksumElement = modulus >> shift & 0x1F;
            byte checksumByte = (byte)checksumElement;
            checksumBuffer.put(checksumByte);
        }
        return checksumBuffer.array();
    }
}

