/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.armor;

import com.exceptionfactory.jagged.framework.armor.ArmoredDecodingException;
import com.exceptionfactory.jagged.framework.armor.ArmoredIndicator;
import com.exceptionfactory.jagged.framework.armor.ArmoredSeparator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

final class ArmoredReadableByteChannel
implements ReadableByteChannel {
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final Base64.Encoder ENCODER_WITH_PADDING = Base64.getEncoder();
    private static final byte END_OF_FILE = -1;
    private static final int MAXIMUM_LINE_LENGTH = 64;
    private static final int MAXIMUM_TERMINATED_LINE_LENGTH = 66;
    private static final int INPUT_BUFFER_CAPACITY = 66560;
    private static final int ENCODED_BUFFER_CAPACITY = 65536;
    private static final int DECODED_BUFFER_CAPACITY = 49152;
    private static final byte LINE_FEED = ArmoredSeparator.LINE_FEED.getCode();
    private static final byte CARRIAGE_RETURN = ArmoredSeparator.CARRIAGE_RETURN.getCode();
    private final ByteBuffer inputBuffer = ByteBuffer.allocate(66560);
    private final ByteBuffer encodedBuffer = ByteBuffer.allocate(65536);
    private final ByteBuffer decodedBuffer = ByteBuffer.allocate(49152);
    private final ByteBuffer lineBuffer = ByteBuffer.allocate(64);
    private final ReadableByteChannel inputChannel;
    private boolean lastEncodedLineFound;

    ArmoredReadableByteChannel(ReadableByteChannel inputChannel) throws IOException {
        this.inputChannel = Objects.requireNonNull(inputChannel, "Input Channel required");
        this.readHeader();
    }

    @Override
    public int read(ByteBuffer outputBuffer) throws IOException {
        Objects.requireNonNull(outputBuffer, "Output Buffer required");
        int read = 0;
        while (outputBuffer.hasRemaining()) {
            int decodedBufferRead = this.readDecodedBuffer(outputBuffer);
            if (-1 == decodedBufferRead) {
                read = -1;
                break;
            }
            read += decodedBufferRead;
        }
        return read;
    }

    @Override
    public boolean isOpen() {
        return this.inputChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.inputChannel.close();
    }

    private void readHeader() throws IOException {
        this.readInputChannel();
        this.readLeading();
        this.readLineBuffer();
        if (this.lineBuffer.limit() == ArmoredIndicator.HEADER.getLength()) {
            byte[] header = this.getLineEncoded();
            if (!Arrays.equals(ArmoredIndicator.HEADER.getIndicator(), header)) {
                throw new ArmoredDecodingException("Header not matched");
            }
        } else {
            throw new ArmoredDecodingException("Header not found");
        }
        this.readEncodedBuffer();
    }

    private void readLeading() {
        this.inputBuffer.mark();
        byte character = this.inputBuffer.get();
        while (Character.isWhitespace(character)) {
            this.inputBuffer.mark();
            character = this.inputBuffer.get();
        }
        this.inputBuffer.reset();
    }

    private void readTrailing() throws IOException {
        while (this.inputBuffer.hasRemaining()) {
            byte character = this.inputBuffer.get();
            if (Character.isWhitespace(character)) continue;
            throw new ArmoredDecodingException(String.format("Character [%d] found after Footer", character));
        }
    }

    private int readDecodedBuffer(ByteBuffer outputBuffer) throws IOException {
        int read = -1;
        if (this.decodedBuffer.hasRemaining()) {
            ++read;
        }
        while (this.decodedBuffer.hasRemaining()) {
            int decodedBufferLimit = this.decodedBuffer.limit();
            if (!outputBuffer.hasRemaining()) break;
            int outputBufferRemaining = outputBuffer.remaining();
            int decodedBufferRemaining = this.decodedBuffer.remaining();
            if (decodedBufferRemaining > outputBufferRemaining) {
                int decodedBufferInputLimit = this.decodedBuffer.position() + outputBufferRemaining;
                this.decodedBuffer.limit(decodedBufferInputLimit);
            }
            int decodedBufferStartPosition = this.decodedBuffer.position();
            outputBuffer.put(this.decodedBuffer);
            this.decodedBuffer.limit(decodedBufferLimit);
            int decodedBufferRead = this.decodedBuffer.position() - decodedBufferStartPosition;
            read += decodedBufferRead;
            if (this.decodedBuffer.remaining() != 0) continue;
            this.readEncodedBuffer();
        }
        if (this.decodedBuffer.remaining() == 0) {
            read = -1;
        }
        return read;
    }

    private void readEncodedBuffer() throws IOException {
        this.decodedBuffer.clear();
        while (this.decodedBuffer.hasRemaining()) {
            this.readInputBuffer();
            if (this.encodedBuffer.hasRemaining()) {
                this.processEncodedBuffer();
                continue;
            }
            this.readLastLineBuffer();
            break;
        }
        this.decodedBuffer.flip();
    }

    private void processEncodedBuffer() throws ArmoredDecodingException {
        if (this.encodedBuffer.limit() == 65536) {
            this.decodeEncodedBuffer();
            this.decodedBuffer.position(49152);
        } else {
            ByteBuffer decoded = this.getDecodedBuffer();
            this.decodedBuffer.put(decoded);
            this.readLastLineBuffer();
        }
    }

    private void readInputBuffer() throws IOException {
        this.encodedBuffer.clear();
        while (this.encodedBuffer.hasRemaining()) {
            this.readLineBuffer();
            if (this.lineBuffer.limit() == 64) {
                if (this.lastEncodedLineFound) {
                    String message = String.format("Short line less than standard length [%d] found before last line", 64);
                    throw new ArmoredDecodingException(message);
                }
                this.encodedBuffer.put(this.lineBuffer);
                this.lineBuffer.clear();
                continue;
            }
            if (this.lineBuffer.limit() == ArmoredIndicator.FOOTER.getLength()) {
                this.readFooter();
                break;
            }
            if (this.lineBuffer.limit() != 0) break;
            throw new ArmoredDecodingException("Empty line found before Footer");
        }
        this.encodedBuffer.flip();
    }

    private void readLastLineBuffer() throws ArmoredDecodingException {
        if (this.lineBuffer.hasRemaining()) {
            byte[] lineEncoded = this.getLineEncoded();
            byte[] decoded = this.getDecoded(lineEncoded);
            byte[] encodedWithPadding = ENCODER_WITH_PADDING.encode(decoded);
            if (!Arrays.equals(encodedWithPadding, lineEncoded)) {
                throw new ArmoredDecodingException("Base64 canonical padding not found");
            }
            this.decodedBuffer.put(decoded);
            this.lastEncodedLineFound = true;
        }
    }

    private void readFooter() throws IOException {
        byte[] footer = new byte[ArmoredIndicator.FOOTER.getLength()];
        this.lineBuffer.get(footer);
        if (Arrays.equals(ArmoredIndicator.FOOTER.getIndicator(), footer)) {
            this.readTrailing();
        } else {
            this.lineBuffer.rewind();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readLineBuffer() throws IOException {
        byte character;
        if (this.inputBuffer.remaining() < 66) {
            this.inputBuffer.compact();
            this.readInputChannel();
        }
        int readBufferRemaining = Math.min(this.inputBuffer.remaining(), 64);
        for (int i = 0; i < readBufferRemaining && LINE_FEED != (character = this.inputBuffer.get()); ++i) {
            if (CARRIAGE_RETURN == character) {
                byte endCharacter = this.inputBuffer.get();
                if (LINE_FEED == endCharacter) break;
                throw new ArmoredDecodingException(String.format("Line Feed [%d] character not found after Carriage Return", LINE_FEED));
            }
            this.lineBuffer.put(character);
        }
        if (this.lineBuffer.position() == 64) {
            byte character2 = this.inputBuffer.get();
            if (LINE_FEED == character2) {
                this.lineBuffer.flip();
                return;
            } else {
                if (CARRIAGE_RETURN != character2) throw new ArmoredDecodingException(String.format("Maximum line length [%d] exceeded", 64));
                byte endCharacter = this.inputBuffer.get();
                if (LINE_FEED != endCharacter) throw new ArmoredDecodingException(String.format("Line Feed [%d] character not found after Carriage Return", LINE_FEED));
                this.lineBuffer.flip();
            }
            return;
        } else {
            this.lineBuffer.flip();
        }
    }

    private void readInputChannel() throws IOException {
        int read;
        while (this.inputBuffer.hasRemaining() && -1 != (read = this.inputChannel.read(this.inputBuffer))) {
        }
        this.inputBuffer.flip();
    }

    private byte[] getLineEncoded() {
        byte[] lineEncoded = new byte[this.lineBuffer.limit()];
        this.lineBuffer.get(lineEncoded);
        this.lineBuffer.clear();
        return lineEncoded;
    }

    private byte[] getDecoded(byte[] encoded) throws ArmoredDecodingException {
        try {
            return DECODER.decode(encoded);
        }
        catch (IllegalArgumentException e) {
            throw new ArmoredDecodingException("Base64 line decoding failed", e);
        }
    }

    private ByteBuffer getDecodedBuffer() throws ArmoredDecodingException {
        try {
            return DECODER.decode(this.encodedBuffer);
        }
        catch (IllegalArgumentException e) {
            throw new ArmoredDecodingException("Base64 buffer decoding failed", e);
        }
    }

    private void decodeEncodedBuffer() throws ArmoredDecodingException {
        try {
            DECODER.decode(this.encodedBuffer.array(), this.decodedBuffer.array());
        }
        catch (IllegalArgumentException e) {
            throw new ArmoredDecodingException("Base64 decoding failed", e);
        }
    }
}

