/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.CryptographicAlgorithm;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

final class CipherFactory {
    private final Provider provider;

    CipherFactory() {
        this.provider = null;
    }

    CipherFactory(Provider provider) {
        this.provider = Objects.requireNonNull(provider, "Provider required");
    }

    Cipher getInitializedCipher(CipherMode cipherMode, CipherKey cipherKey, IvParameterSpec parameterSpec) throws GeneralSecurityException {
        Objects.requireNonNull(cipherMode, "Cipher Mode required");
        Objects.requireNonNull(cipherKey, "Cipher Symmetric Key required");
        Objects.requireNonNull(parameterSpec, "Parameter Specification required");
        Cipher cipher = this.getCipher();
        cipher.init(cipherMode.mode, (Key)cipherKey, parameterSpec);
        return cipher;
    }

    private Cipher getCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = this.provider == null ? Cipher.getInstance(CryptographicAlgorithm.CHACHA20_POLY1305.getAlgorithm()) : Cipher.getInstance(CryptographicAlgorithm.CHACHA20_POLY1305.getAlgorithm(), this.provider);
        return cipher;
    }

    static enum CipherMode {
        DECRYPT(2),
        ENCRYPT(1);

        private final int mode;

        private CipherMode(int mode) {
            this.mode = mode;
        }
    }
}

