/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.framework.crypto.ByteBufferEncryptor;
import com.exceptionfactory.jagged.framework.crypto.CipherFactory;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

final class StandardByteBufferEncryptor
implements ByteBufferEncryptor {
    private final Cipher cipher;

    StandardByteBufferEncryptor(CipherFactory cipherFactory, CipherKey cipherKey, IvParameterSpec parameterSpec) throws GeneralSecurityException {
        Objects.requireNonNull(cipherFactory, "Cipher Factory required");
        Objects.requireNonNull(cipherKey, "Cipher Key required");
        Objects.requireNonNull(parameterSpec, "Parameter Specification required");
        this.cipher = cipherFactory.getInitializedCipher(CipherFactory.CipherMode.ENCRYPT, cipherKey, parameterSpec);
    }

    @Override
    public int encrypt(ByteBuffer inputBuffer, ByteBuffer outputBuffer) throws GeneralSecurityException {
        Objects.requireNonNull(inputBuffer, "Input Buffer required");
        Objects.requireNonNull(outputBuffer, "Output Buffer required");
        return this.cipher.doFinal(inputBuffer, outputBuffer);
    }
}

