/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.framework.crypto.CipherFactory;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.EncryptedFileKey;
import com.exceptionfactory.jagged.framework.crypto.FileKeyEncryptor;
import com.exceptionfactory.jagged.framework.crypto.FileKeyIvParameterSpec;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Objects;
import javax.crypto.Cipher;

class StandardFileKeyEncryptor
implements FileKeyEncryptor {
    private final CipherFactory cipherFactory;

    StandardFileKeyEncryptor() {
        this.cipherFactory = new CipherFactory();
    }

    StandardFileKeyEncryptor(Provider provider) {
        this.cipherFactory = new CipherFactory(provider);
    }

    @Override
    public EncryptedFileKey getEncryptedFileKey(FileKey fileKey, CipherKey cipherKey) throws GeneralSecurityException {
        Objects.requireNonNull(fileKey, "File Key required");
        Objects.requireNonNull(cipherKey, "Cipher Key required");
        FileKeyIvParameterSpec parameterSpec = new FileKeyIvParameterSpec();
        Cipher cipher = this.cipherFactory.getInitializedCipher(CipherFactory.CipherMode.ENCRYPT, cipherKey, parameterSpec);
        byte[] fileKeyEncoded = fileKey.getEncoded();
        byte[] encryptedFileKey = cipher.doFinal(fileKeyEncoded);
        return new EncryptedFileKey(encryptedFileKey);
    }
}

