/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.framework.crypto.CryptographicKeyType;
import com.exceptionfactory.jagged.framework.crypto.HashedDerivedKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.HeaderKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.MacKey;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.crypto.SecretKey;

class StandardHeaderKeyProducer
extends HashedDerivedKeyProducer
implements HeaderKeyProducer {
    private static final byte[] EMPTY_SALT = new byte[CryptographicKeyType.HEADER_KEY.getKeyLength()];
    private static final MacKey EMPTY_SALT_KEY = new MacKey(EMPTY_SALT, CryptographicKeyType.HEADER_KEY);
    private static final byte[] HEADER_INFO = new byte[]{104, 101, 97, 100, 101, 114};

    StandardHeaderKeyProducer() {
    }

    @Override
    public MacKey getHeaderKey(FileKey fileKey) throws GeneralSecurityException {
        Objects.requireNonNull(fileKey, "File Key required");
        byte[] headerKey = this.getDerivedKey((SecretKey)fileKey, EMPTY_SALT_KEY, HEADER_INFO);
        return new MacKey(headerKey, CryptographicKeyType.HEADER_KEY);
    }
}

