/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.format;

import com.exceptionfactory.jagged.RecipientStanza;
import com.exceptionfactory.jagged.framework.codec.CanonicalBase64;
import com.exceptionfactory.jagged.framework.format.FileHeader;
import com.exceptionfactory.jagged.framework.format.FileHeaderReader;
import com.exceptionfactory.jagged.framework.format.HeaderDecodingException;
import com.exceptionfactory.jagged.framework.format.SectionIndicator;
import com.exceptionfactory.jagged.framework.format.SectionSeparator;
import com.exceptionfactory.jagged.framework.format.StandardFileHeader;
import com.exceptionfactory.jagged.framework.format.StandardRecipientStanza;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

final class StandardFileHeaderReader
implements FileHeaderReader {
    private static final int MAXIMUM_LINE_LENGTH = 64;
    private static final int ENCODED_MAC_LENGTH = 43;
    private static final byte EXCLAMATION_MARK_CHARACTER = 33;
    private static final byte TILDE_CHARACTER_CODE = 126;
    private static final CanonicalBase64.Decoder DECODER = CanonicalBase64.getDecoder();

    StandardFileHeaderReader() {
    }

    @Override
    public FileHeader getFileHeader(ByteBuffer inputBuffer) throws GeneralSecurityException {
        Objects.requireNonNull(inputBuffer, "Input Buffer required");
        this.readVersion(inputBuffer);
        List<RecipientStanza> recipientStanzas = this.readRecipientStanzas(inputBuffer);
        if (inputBuffer.hasRemaining()) {
            byte separator = inputBuffer.get();
            if (SectionSeparator.SPACE.getCode() == separator) {
                byte[] messageAuthenticationCode = this.readMessageAuthenticationCode(inputBuffer);
                return new StandardFileHeader(recipientStanzas, messageAuthenticationCode);
            }
            String message = String.format("Byte [%d] found instead of Space after End Header", separator);
            throw new HeaderDecodingException(message);
        }
        throw new HeaderDecodingException("Message Authentication Code not found after Recipient Stanzas");
    }

    private void readVersion(ByteBuffer inputBuffer) throws HeaderDecodingException {
        if (SectionIndicator.VERSION.getLength() >= inputBuffer.remaining()) {
            throw new HeaderDecodingException("Version not found");
        }
        byte[] version = new byte[SectionIndicator.VERSION.getLength()];
        inputBuffer.get(version);
        if (Arrays.equals(SectionIndicator.VERSION.getIndicator(), version)) {
            byte code = inputBuffer.get();
            if (SectionSeparator.LINE_FEED.getCode() != code) {
                throw new HeaderDecodingException(String.format("Byte [%d] found instead of Line Feed after Version", code));
            }
        } else {
            throw new HeaderDecodingException("Supported version not found");
        }
    }

    private List<RecipientStanza> readRecipientStanzas(ByteBuffer inputBuffer) throws HeaderDecodingException {
        ArrayList<RecipientStanza> recipientStanzas = new ArrayList<RecipientStanza>();
        while (inputBuffer.hasRemaining()) {
            int inputPosition = inputBuffer.position();
            byte[] argumentIndicator = new byte[SectionIndicator.STANZA.getLength()];
            inputBuffer.get(argumentIndicator);
            if (Arrays.equals(SectionIndicator.STANZA.getIndicator(), argumentIndicator)) {
                String type = this.readType(inputBuffer);
                List<String> arguments = this.readArguments(inputBuffer);
                byte[] body = this.readBody(inputBuffer);
                StandardRecipientStanza recipientStanza = new StandardRecipientStanza(type, arguments, body);
                recipientStanzas.add(recipientStanza);
                continue;
            }
            if (Arrays.equals(SectionIndicator.END.getIndicator(), argumentIndicator)) break;
            inputBuffer.position(inputPosition);
            break;
        }
        return recipientStanzas;
    }

    private String readType(ByteBuffer inputBuffer) {
        StringBuilder builder = new StringBuilder();
        while (inputBuffer.hasRemaining()) {
            int inputPosition = inputBuffer.position();
            byte read = inputBuffer.get();
            if (SectionSeparator.SPACE.getCode() == read || SectionSeparator.LINE_FEED.getCode() == read) {
                inputBuffer.position(inputPosition);
                break;
            }
            char character = (char)read;
            builder.append(character);
        }
        return builder.toString();
    }

    private List<String> readArguments(ByteBuffer inputBuffer) throws HeaderDecodingException {
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int lastRead = 0;
        while (inputBuffer.hasRemaining()) {
            byte read = inputBuffer.get();
            if (SectionSeparator.LINE_FEED.getCode() == read) {
                this.setArgument(builder, arguments);
                break;
            }
            if (SectionSeparator.SPACE.getCode() == read) {
                if (SectionSeparator.SPACE.getCode() == lastRead) {
                    throw new HeaderDecodingException("Recipient Stanza empty argument found");
                }
                this.setArgument(builder, arguments);
                builder = new StringBuilder();
            } else {
                if (this.isInvalidCharacter(read)) {
                    String message = String.format("Recipient Stanza invalid character code [%d]", read);
                    throw new HeaderDecodingException(message);
                }
                char character = (char)read;
                builder.append(character);
            }
            lastRead = read;
        }
        return arguments;
    }

    private void setArgument(StringBuilder builder, List<String> arguments) {
        if (builder.length() > 0) {
            String argument = builder.toString();
            arguments.add(argument);
        }
    }

    private byte[] readBody(ByteBuffer inputBuffer) throws HeaderDecodingException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int lineLength = 0;
        while (inputBuffer.hasRemaining()) {
            byte read = inputBuffer.get();
            if (SectionSeparator.LINE_FEED.getCode() == read) {
                if (lineLength < 64) break;
                if (lineLength > 64) {
                    String message = String.format("Recipient Stanza Body line length [%d] greater than maximum [%d]", lineLength, 64);
                    throw new HeaderDecodingException(message);
                }
                lineLength = 0;
                continue;
            }
            ++lineLength;
            outputStream.write(read);
        }
        byte[] encoded = outputStream.toByteArray();
        try {
            return DECODER.decode(encoded);
        }
        catch (RuntimeException e) {
            throw new HeaderDecodingException("Recipient Stanza Body decoding failed", e);
        }
    }

    private byte[] readMessageAuthenticationCode(ByteBuffer buffer) throws HeaderDecodingException {
        if (buffer.remaining() < 43) {
            throw new HeaderDecodingException("Message Authentication Code not found");
        }
        byte[] encoded = new byte[43];
        buffer.get(encoded);
        byte[] decoded = this.getDecoded(encoded);
        byte code = buffer.get();
        if (SectionSeparator.LINE_FEED.getCode() == code) {
            return decoded;
        }
        String message = String.format("Byte [%d] found instead of Line Feed after Message Authentication Code", code);
        throw new HeaderDecodingException(message);
    }

    private boolean isInvalidCharacter(byte character) {
        return character < 33 || character > 126;
    }

    private byte[] getDecoded(byte[] encoded) throws HeaderDecodingException {
        try {
            return DECODER.decode(encoded);
        }
        catch (IllegalArgumentException e) {
            throw new HeaderDecodingException("Message Authentication Code decoding failed", e);
        }
    }
}

